/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.handler;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.collect.ImmutableList;
import com.sonatype.analytics.AnalyticsMarker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Singleton
@Named(value="nexus.analytics.nuget.odataRequestsAnalytics")
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class AnalyticsNugetOdataRequestsHandler
extends ComponentSupport
implements Handler,
AnalyticsMarker {
    protected static final String ANALYTICS_NUGET_ODATA_REQUESTS_HANDLER = "nexus.analytics.nuget.odataRequestsAnalytics";
    private static final String PACKAGES = "Packages";
    private static final List<String> DEPRECATED_PACKAGES_PARAMETERS = ImmutableList.of((Object)"tolower", (Object)"substring", (Object)"startswith");
    private static final String FIND_PACKAGES_BY_ID = "FindPackagesById";
    private static final List<String> DEPRECATED_FIND_PACKAGES_BY_ID_PARAMETERS = ImmutableList.of((Object)"Version", (Object)"LastUpdated");
    private final Map<String, Integer> deprecatedRequestsStatistics = new HashMap<String, Integer>();

    @CachedGauge(name="nexus.analytics.nuget.v2.odataDeprecatedRequestsCount", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public Map<String, Integer> deprecatedRequestsStatistics() {
        return this.deprecatedRequestsStatistics;
    }

    private synchronized void countOdataRequests(String requestDescription) {
        int count = this.deprecatedRequestsStatistics.getOrDefault(requestDescription, 0);
        this.deprecatedRequestsStatistics.put(requestDescription, count + 1);
    }

    private void countFindPackagesByIdRequests(Context context) {
        String orderByParameter = context.getRequest().getParameters().get("$orderby");
        if (orderByParameter != null) {
            for (String deprecatedParameter : DEPRECATED_FIND_PACKAGES_BY_ID_PARAMETERS) {
                if (!orderByParameter.contains(deprecatedParameter)) continue;
                this.countOdataRequests("FindPackagesById: orderby=" + deprecatedParameter);
            }
        }
    }

    private void countPackagesRequests(Context context) {
        String uri = String.valueOf(context.getRequest().getPath()) + context.getRequest().getParameters().toString();
        if (uri.contains("$count") && !uri.contains("id=") && !uri.contains("version=")) {
            this.countOdataRequests("Packages: count");
        }
        for (String deprecatedParameter : DEPRECATED_PACKAGES_PARAMETERS) {
            if (!uri.contains(deprecatedParameter)) continue;
            this.countOdataRequests("Packages: " + deprecatedParameter);
        }
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        String operation;
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().get(TokenMatcher.State.class);
        String string = operation = state != null ? (String)state.getTokens().get("operation") : null;
        if (operation != null) {
            if (operation.equals(FIND_PACKAGES_BY_ID)) {
                this.countFindPackagesByIdRequests(context);
            }
            if (operation.equals(PACKAGES)) {
                this.countPackagesRequests(context);
            }
        }
        return context.proceed();
    }

    @Override
    public void reset() {
        this.deprecatedRequestsStatistics.clear();
    }
}

