/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.handler;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.annotations.VisibleForTesting;
import com.sonatype.analytics.AnalyticsMarker;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.security.UserIdHelper;

@Singleton
@Named(value="nexus.analytics.npmAuditHandler")
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class AnalyticsNpmAuditHandler
extends ComponentSupport
implements Handler,
AnalyticsMarker {
    public static final String ANALYTICS_NPM_AUDIT_HANDLER = "nexus.analytics.npmAuditHandler";
    private final AtomicInteger requestCount = new AtomicInteger();
    private final Set<String> userIds = ConcurrentHashMap.newKeySet();

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        this.updateAnalytics();
        return context.proceed();
    }

    @CachedGauge(name="nexus.analytics.npm_audit_request_count", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public int requestCount() {
        return this.requestCount.get();
    }

    @CachedGauge(name="nexus.analytics.npm_audit_unique_user_count", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public int uniqueUserCount() {
        return this.userIds.size();
    }

    @Override
    public void reset() {
        this.requestCount.set(0);
        this.userIds.clear();
    }

    @VisibleForTesting
    void updateAnalytics() {
        this.requestCount.incrementAndGet();
        this.userIds.add(this.userId());
    }

    protected String userId() {
        return UserIdHelper.get();
    }
}

