/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.filter;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import com.sonatype.analytics.AnalyticsMarker;
import com.sonatype.analytics.internal.metrics.ServiceRestRequestMeterGauge;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.web.servlet.AdviceFilter;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.siesta.SiestaResourceMethodFinder;

@Singleton
@Named
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class AnalyticsMeteringFilter
extends AdviceFilter
implements AnalyticsMarker {
    protected final Logger log = Loggers.getLogger((Object)this);
    public static final String SERVICE_REST_REQUEST_RATES = "service_rest_request_rates";
    public static final String SERVICE_REST_REQUEST_GAUGE_NAME = "nexus.analytics.service_rest_request_rates";
    private final MetricRegistry metricRegistry;

    @Inject
    public AnalyticsMeteringFilter(MetricRegistry metricRegistry) {
        this.metricRegistry = (MetricRegistry)Preconditions.checkNotNull((Object)metricRegistry);
    }

    protected boolean preHandle(ServletRequest servletRequest, ServletResponse servletResponse) {
        try {
            this.mark((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
        }
        catch (Exception e) {
            this.log.error("Error metering request {}", (Object)e.getMessage(), (Object)(this.log.isDebugEnabled() ? e : null));
        }
        return true;
    }

    @Override
    public void reset() {
        this.metricRegistry.remove(SERVICE_REST_REQUEST_GAUGE_NAME);
    }

    private void mark(HttpServletRequest request, HttpServletResponse response) {
        String method = request.getMethod();
        String path = this.siestaResourceMethodFinder((ServletRequest)request).getResourceMethodPath(request, response);
        this.log.debug("Collecting analytics for request {} {}", (Object)method, (Object)path);
        this.gauge().mark(method, path);
    }

    private ServiceRestRequestMeterGauge gauge() {
        return (ServiceRestRequestMeterGauge)this.metricRegistry.gauge(SERVICE_REST_REQUEST_GAUGE_NAME, ServiceRestRequestMeterGauge::new);
    }

    private SiestaResourceMethodFinder siestaResourceMethodFinder(ServletRequest servletRequest) {
        return (SiestaResourceMethodFinder)servletRequest.getServletContext().getAttribute(SiestaResourceMethodFinder.class.getName());
    }
}

