/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.capability;

import com.sonatype.analytics.internal.capability.AnalyticsCapability;
import com.sonatype.analytics.internal.capability.AnalyticsCapabilityConfiguration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.capability.CapabilityDescriptorSupport;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.Tag;
import org.sonatype.nexus.capability.Taggable;
import org.sonatype.nexus.formfields.CheckboxFormField;
import org.sonatype.nexus.formfields.FormField;

@Named(value="analytics-configuration")
@Singleton
public class AnalyticsCapabilityDescriptor
extends CapabilityDescriptorSupport<AnalyticsCapabilityConfiguration>
implements Taggable {
    static final Messages messages = (Messages)I18N.create(Messages.class);
    private final CheckboxFormField analyticsEnabled;

    public AnalyticsCapabilityDescriptor() {
        this.setExposed(false);
        this.setHidden(true);
        this.analyticsEnabled = new CheckboxFormField("submitAnalytics", messages.submitAnalyticsLabel(), messages.submitAnalyticsHelp(), false);
    }

    public CapabilityType type() {
        return AnalyticsCapability.TYPE;
    }

    public String name() {
        return messages.name();
    }

    public List<FormField> formFields() {
        return Collections.singletonList(this.analyticsEnabled);
    }

    protected AnalyticsCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new AnalyticsCapabilityConfiguration(properties);
    }

    protected String renderAbout() {
        return this.render("analytics-configuration-about.vm");
    }

    public void setExposed(boolean exposed) {
        super.setExposed(exposed);
    }

    public Set<Tag> getTags() {
        return Collections.singleton(Tag.categoryTag((String)messages.category()));
    }

    static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Analytics: Configuration")
        public String name();

        @MessageBundle.DefaultMessage(value="Metrics")
        public String category();

        @MessageBundle.DefaultMessage(value="Disabled")
        public String disabled();

        @MessageBundle.DefaultMessage(value="Enabled")
        public String enabled();

        @MessageBundle.DefaultMessage(value="Submit Analytics")
        public String submitAnalyticsLabel();

        @MessageBundle.DefaultMessage(value="Select this option to provide limited metrics about the server to Sonatype.")
        public String submitAnalyticsHelp();
    }
}

