/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.capability;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.sonatype.nexus.capability.CapabilityConfigurationSupport;

public class AnalyticsCapabilityConfiguration
extends CapabilityConfigurationSupport {
    public static final String SUBMIT_ANALYTICS = "submitAnalytics";
    public static final boolean DEFAULT_SUBMIT_ANALYTICS = false;
    private boolean submitAnalytics;

    public AnalyticsCapabilityConfiguration(Map<String, String> properties) {
        Preconditions.checkNotNull(properties);
        this.submitAnalytics = this.parseBoolean(properties.get(SUBMIT_ANALYTICS), false);
    }

    public boolean isSubmitAnalytics() {
        return this.submitAnalytics;
    }

    public AnalyticsCapabilityConfiguration setSubmitAnalytics(boolean submitAnalytics) {
        this.submitAnalytics = submitAnalytics;
        return this;
    }

    public Map<String, String> asMap() {
        HashMap props = Maps.newHashMap();
        props.put(SUBMIT_ANALYTICS, String.valueOf(this.submitAnalytics));
        return props;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "submitAnalytics=" + this.submitAnalytics + '}';
    }
}

