/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.capability;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.eventbus.Subscribe;
import com.sonatype.analytics.internal.capability.AnalyticsCapability;
import com.sonatype.analytics.internal.capability.AnalyticsCapabilityDescriptor;
import com.sonatype.nexus.licensing.ext.LicenseChangedEvent;
import com.sonatype.nexus.licensing.ext.NexusProfessionalFeature;
import com.sonatype.nexus.licensing.ext.capability.LicensingConditions;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.Lifecycle;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.nexus.capability.CapabilityBooterSupport;
import org.sonatype.nexus.capability.CapabilityContext;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
public class AnalyticsCapabilityBooter
extends CapabilityBooterSupport
implements Lifecycle,
EventAware,
EventAware.Asynchronous {
    private volatile CapabilityRegistry registry;
    private final Condition licenseIsValid;
    private final AnalyticsCapabilityDescriptor analyticsCapabilityDescriptor;

    @Inject
    public AnalyticsCapabilityBooter(AnalyticsCapabilityDescriptor analyticsCapabilityDescriptor, NexusProfessionalFeature feature, LicensingConditions licensingConditions) {
        this.analyticsCapabilityDescriptor = (AnalyticsCapabilityDescriptor)((Object)Preconditions.checkNotNull((Object)((Object)analyticsCapabilityDescriptor)));
        Preconditions.checkNotNull((Object)feature);
        this.licenseIsValid = ((LicensingConditions)Preconditions.checkNotNull((Object)licensingConditions)).licenseIsValid((Feature)feature);
    }

    protected void boot(CapabilityRegistry registry) throws Exception {
        this.registry = registry;
        if (this.licenseIsValid.isSatisfied()) {
            this.setProConfiguration();
        } else {
            this.analyticsCapabilityDescriptor.setExposed(true);
        }
    }

    @Subscribe
    public void on(LicenseChangedEvent event) {
        CapabilityRegistry registry = this.registry;
        if (registry == null) {
            this.log.debug("License valid:{} but booter up", (Object)event.isLicenseValid());
            return;
        }
        if (event.isLicenseInstalled() && event.isLicenseValid()) {
            this.setProConfiguration();
        } else {
            this.analyticsCapabilityDescriptor.setExposed(true);
            Optional.ofNullable(this.findCapability(registry, AnalyticsCapability.TYPE)).map(CapabilityReference::context).map(CapabilityContext::id).ifPresent(arg_0 -> ((CapabilityRegistry)registry).remove(arg_0));
        }
    }

    public void start() throws Exception {
        this.licenseIsValid.bind();
        if (this.licenseIsValid.isSatisfied()) {
            this.setProConfiguration();
        } else {
            this.analyticsCapabilityDescriptor.setExposed(true);
        }
    }

    public void stop() throws Exception {
        this.licenseIsValid.release();
    }

    private CapabilityReference setProConfiguration() {
        this.analyticsCapabilityDescriptor.setExposed(false);
        if (this.registry == null) {
            return null;
        }
        return this.findExisting().findFirst().map(CapabilityReference::context).map(CapabilityContext::id).map(arg_0 -> ((CapabilityRegistry)this.registry).enable(arg_0)).orElseGet(this::addCapability);
    }

    @Nullable
    private CapabilityReference addCapability() {
        try {
            this.maybeAddCapability(this.registry, AnalyticsCapability.TYPE, true, "Automatically Created", Collections.singletonMap("submitAnalytics", String.valueOf(true)));
            return this.findCapability(this.registry, AnalyticsCapability.TYPE);
        }
        catch (Exception e) {
            this.log.debug("Failed to add analytics capability", (Throwable)e);
            return null;
        }
    }

    private Stream<? extends CapabilityReference> findExisting() {
        return this.registry.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(AnalyticsCapability.TYPE)).stream();
    }
}

