/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.Subscribe;
import com.sonatype.analytics.AnalyticsMarker;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.security.authc.NexusAuthenticationEvent;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class UserAnalytics
extends ComponentSupport
implements AnalyticsMarker,
EventAware {
    private final Map<String, LocalDateTime> lastSuccessfulLogins = new ConcurrentHashMap<String, LocalDateTime>();
    private final Map<String, LocalDateTime> lastFailedLogins = new ConcurrentHashMap<String, LocalDateTime>();

    @Subscribe
    public void on(NexusAuthenticationEvent event) {
        String userid = event.getClientInfo().getUserid();
        if (event.isSuccessful()) {
            this.lastSuccessfulLogins.put(userid, this.now());
        } else {
            this.lastFailedLogins.put(userid, this.now());
        }
    }

    @CachedGauge(name="nexus.analytics.unique_user_authentications_count", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public Map<String, Integer> uniqueUserAuthenticationsInLastIntervals() {
        LocalDateTime now = this.now();
        LocalDateTime weekAgo = now.minusDays(7L);
        this.lastSuccessfulLogins.values().removeIf(value -> value.isBefore(weekAgo));
        this.lastFailedLogins.values().removeIf(value -> value.isBefore(weekAgo));
        LocalDateTime dayAgo = now.minusDays(1L);
        HashMap<String, LocalDateTime> lastSuccessfulLogins24h = new HashMap<String, LocalDateTime>(this.lastSuccessfulLogins);
        HashMap<String, LocalDateTime> lastFailedLogins24h = new HashMap<String, LocalDateTime>(this.lastFailedLogins);
        lastSuccessfulLogins24h.values().removeIf(value -> value.isBefore(dayAgo));
        lastFailedLogins24h.values().removeIf(value -> value.isBefore(dayAgo));
        return ImmutableMap.of((Object)"successful_last_7d", (Object)this.lastSuccessfulLogins.size(), (Object)"failed_last_7d", (Object)this.lastFailedLogins.size(), (Object)"successful_last_24h", (Object)lastSuccessfulLogins24h.size(), (Object)"failed_last_24h", (Object)lastFailedLogins24h.size());
    }

    protected LocalDateTime now() {
        return LocalDateTime.now();
    }
}

