/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.Subscribe;
import com.sonatype.analytics.AnalyticsMarker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.events.TaskEventStoppedDone;
import org.sonatype.nexus.scheduling.events.TaskEventStoppedFailed;
import org.sonatype.nexus.scheduling.spi.SchedulerSPI;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class ScheduledTaskAnalytics
implements AnalyticsMarker,
EventAware {
    private final SchedulerSPI schedulerSPI;
    private final Map<String, List<Map<String, Object>>> taskMetrics = new HashMap<String, List<Map<String, Object>>>();
    private final Map<String, AtomicLong> taskFailureMetrics = new HashMap<String, AtomicLong>();

    @Inject
    public ScheduledTaskAnalytics(SchedulerSPI schedulerSPI) {
        this.schedulerSPI = (SchedulerSPI)Preconditions.checkNotNull((Object)schedulerSPI);
    }

    @CachedGauge(name="nexus.analytics.tasks", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public List<Map<String, Object>> countTasksByTypeId() {
        List taskInfos = this.schedulerSPI.listsTasks();
        List taskList = taskInfos.stream().collect(Collectors.groupingBy(TaskInfo::getTypeId, Collectors.counting())).entrySet().stream().map(e -> ImmutableMap.of((Object)"name", e.getKey(), (Object)"instance_count", e.getValue(), (Object)"run_count", (Object)this.getNumberOfRuns((String)e.getKey()), (Object)"run_duration_avg_ms", (Object)this.getDurationAverage((String)e.getKey()), (Object)"failure_count", (Object)this.getNumberOfFailures((String)e.getKey()).longValue())).collect(Collectors.toList());
        List configuredTaskTypeIds = taskInfos.stream().map(TaskInfo::getTypeId).distinct().collect(Collectors.toList());
        List noInstanceTaskList = this.taskMetrics.entrySet().stream().filter(e -> !configuredTaskTypeIds.contains(e.getKey())).map(e -> ImmutableMap.of((Object)"name", e.getKey(), (Object)"instance_count", (Object)0L, (Object)"run_count", (Object)this.getNumberOfRuns((String)e.getKey()), (Object)"run_duration_avg_ms", (Object)this.getDurationAverage((String)e.getKey()), (Object)"failure_count", (Object)this.getNumberOfFailures((String)e.getKey()).longValue())).collect(Collectors.toList());
        return Stream.concat(taskList.stream(), noInstanceTaskList.stream()).collect(Collectors.toList());
    }

    @Subscribe
    public void on(TaskEventStoppedDone event) {
        this.taskMetrics.computeIfAbsent(event.getTaskInfo().getTypeId(), s -> new ArrayList()).add(new HashMap(event.getTaskInfo().getContext()));
    }

    @Subscribe
    public void on(TaskEventStoppedFailed event) {
        this.getNumberOfFailures(event.getTaskInfo().getTypeId()).incrementAndGet();
    }

    private int getNumberOfRuns(String taskType) {
        List<Map<String, Object>> attributes = this.taskMetrics.get(taskType);
        if (attributes != null) {
            return attributes.size();
        }
        return 0;
    }

    private AtomicLong getNumberOfFailures(String taskType) {
        return this.taskFailureMetrics.computeIfAbsent(taskType, key -> new AtomicLong());
    }

    private Double getDurationAverage(String taskType) {
        List<Map<String, Object>> attributes = this.taskMetrics.get(taskType);
        if (attributes != null) {
            return attributes.stream().collect(Collectors.summarizingLong(m -> (Long)m.get("duration_ms"))).getAverage();
        }
        return 0.0;
    }

    @Override
    public void reset() {
        this.taskMetrics.clear();
        this.taskFailureMetrics.clear();
    }
}

