/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sonatype.analytics.AnalyticsMarker;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.datastore.api.DataStore;
import org.sonatype.nexus.datastore.api.DataStoreConfiguration;
import org.sonatype.nexus.datastore.api.DataStoreManager;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class DataStoreAnalytics
extends ComponentSupport
implements AnalyticsMarker {
    private static final String ORIENT_DB_NAME = "OrientDB";
    private final boolean orientEnabled;
    private final DataStoreManager dataStoreManager;

    @Inject
    public DataStoreAnalytics(@Named(value="nexus.orient.enabled") boolean orientEnabled, DataStoreManager dataStoreManager) {
        this.orientEnabled = orientEnabled;
        this.dataStoreManager = (DataStoreManager)Preconditions.checkNotNull((Object)dataStoreManager);
    }

    @CachedGauge(name="nexus.analytics.data_store", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public Map<String, String> metricsByDbType() {
        if (this.orientEnabled) {
            return ImmutableMap.of((Object)"nexus", (Object)ORIENT_DB_NAME);
        }
        return StreamSupport.stream(this.dataStoreManager.browse().spliterator(), false).map(this::getDbAnalyticsEntity).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private AbstractMap.SimpleEntry<String, String> getDbAnalyticsEntity(DataStore<?> dataStore) {
        DataStoreConfiguration configuration = dataStore.getConfiguration();
        String databaseProductName = "";
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = dataStore.getDataSource().getConnection();){
                databaseProductName = connection.getMetaData().getDatabaseProductName();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            this.log.error("Can't collect data store analytics", (Throwable)e);
        }
        return new AbstractMap.SimpleEntry<String, String>(configuration.getName(), databaseProductName);
    }
}

