/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.collect.ImmutableMap;
import com.sonatype.analytics.AnalyticsMarker;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyStorage;
import org.sonatype.nexus.common.app.FeatureFlag;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class CleanupAnalytics
implements AnalyticsMarker {
    @Inject
    private CleanupPolicyStorage cleanupPolicyStorage;

    @CachedGauge(name="nexus.analytics.cleanup_policy_count", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public Long count() {
        return this.cleanupPolicyStorage.count();
    }

    @CachedGauge(name="nexus.analytics.cleanup_policy_criteria", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public List<Map<String, Object>> countCriteria() {
        return this.cleanupPolicyStorage.getAll().stream().map(CleanupPolicy::getCriteria).map(Map::keySet).flatMap(Collection::stream).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(CleanupAnalytics::createCriteriaMap).collect(Collectors.toList());
    }

    private static Map<String, Object> createCriteriaMap(Map.Entry<String, Long> entry) {
        return ImmutableMap.of((Object)"type", (Object)entry.getKey(), (Object)"count", (Object)entry.getValue());
    }
}

