/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.sonatype.analytics.AnalyticsMarker;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.api.BlobStoreMetrics;
import org.sonatype.nexus.blobstore.api.OperationMetrics;
import org.sonatype.nexus.blobstore.api.OperationType;
import org.sonatype.nexus.blobstore.group.BlobStoreGroup;
import org.sonatype.nexus.common.app.FeatureFlag;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class BlobStoreAnalytics
implements AnalyticsMarker {
    private final BlobStoreManager blobStoreManager;

    @Inject
    public BlobStoreAnalytics(BlobStoreManager blobStoreManager) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
    }

    @CachedGauge(name="nexus.analytics.blobstore_type_counts", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public Map<String, Long> countByType() {
        return Streams.stream((Iterable)this.blobStoreManager.browse()).collect(Collectors.groupingBy(t -> t.getBlobStoreConfiguration().getType(), Collectors.counting()));
    }

    @CachedGauge(name="nexus.analytics.blobstore_group_counts", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public Map<String, Object> countByGroup() {
        return this.toGroupMemberCountMap(this.getBlobStoreGroups());
    }

    @CachedGauge(name="nexus.analytics.blobstore_metrics_by_type", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public List<Map<String, Object>> metricsByType() {
        return this.getBlobStoresByType().entrySet().stream().map(entry -> this.aggregateMetrics((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
    }

    @CachedGauge(name="nexus.analytics.blobstore_operation_metrics_by_type", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public List<Map<String, Object>> operationMetricsByType() {
        return this.getBlobStoresByType().entrySet().stream().map(entry -> this.aggregateOperationMetrics((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
    }

    private Map<String, List<BlobStore>> getBlobStoresByType() {
        return Streams.stream((Iterable)this.blobStoreManager.browse()).collect(Collectors.groupingBy(blobstore -> blobstore.getBlobStoreConfiguration().getType()));
    }

    private List<BlobStoreGroup> getBlobStoreGroups() {
        return Streams.stream((Iterable)this.blobStoreManager.browse()).filter(this::isBlobStoreGroup).map(blobStore -> (BlobStoreGroup)blobStore).collect(Collectors.toList());
    }

    private Map<String, Object> toGroupMemberCountMap(List<BlobStoreGroup> blobStoreGroups) {
        return ImmutableMap.of((Object)"groups", (Object)blobStoreGroups.size(), (Object)"members", this.getCountPerMember(blobStoreGroups));
    }

    private List<Integer> getCountPerMember(List<BlobStoreGroup> blobStoreGroups) {
        return blobStoreGroups.stream().map(this::getCountMembers).collect(Collectors.toList());
    }

    private boolean isBlobStoreGroup(BlobStore blobStore) {
        return Objects.nonNull(blobStore.getBlobStoreConfiguration()) && blobStore.getBlobStoreConfiguration().getType().equals("Group");
    }

    private int getCountMembers(BlobStoreGroup blobStoreGroup) {
        return blobStoreGroup.getMembers().size();
    }

    private Map<String, Object> aggregateMetrics(String type, List<BlobStore> blobStores) {
        long blobs = 0L;
        long bytes = 0L;
        for (BlobStore blobStore : blobStores) {
            BlobStoreMetrics metrics = blobStore.getMetrics();
            blobs += metrics.getBlobCount();
            bytes += metrics.getTotalSize();
        }
        return ImmutableMap.of((Object)"type", (Object)type, (Object)"blob_count", (Object)blobs, (Object)"bytes", (Object)bytes);
    }

    private Map<String, Object> aggregateOperationMetrics(String type, List<BlobStore> blobStores) {
        EnumMap<OperationType, Long> totalSuccessfulRequests = new EnumMap<OperationType, Long>(OperationType.class);
        EnumMap<OperationType, Long> totalErrorRequests = new EnumMap<OperationType, Long>(OperationType.class);
        EnumMap<OperationType, Long> totalTimeOnRequests = new EnumMap<OperationType, Long>(OperationType.class);
        EnumMap<OperationType, Long> totalBlobSizeOnRequests = new EnumMap<OperationType, Long>(OperationType.class);
        for (BlobStore blobStore : blobStores) {
            for (Map.Entry metricsEntry : blobStore.getOperationMetricsByType().entrySet()) {
                OperationType operationType = (OperationType)metricsEntry.getKey();
                OperationMetrics operationMetrics = (OperationMetrics)metricsEntry.getValue();
                totalSuccessfulRequests.merge(operationType, operationMetrics.getSuccessfulRequests(), Long::sum);
                totalErrorRequests.merge(operationType, operationMetrics.getErrorRequests(), Long::sum);
                totalTimeOnRequests.merge(operationType, operationMetrics.getTimeOnRequests(), Long::sum);
                totalBlobSizeOnRequests.merge(operationType, operationMetrics.getBlobSize(), Long::sum);
            }
        }
        return ImmutableMap.builder().put((Object)"type", (Object)type).put((Object)"total_successful_requests", totalSuccessfulRequests).put((Object)"total_error_requests", totalErrorRequests).put((Object)"total_time_on_requests", totalTimeOnRequests).put((Object)"total_blob_size_on_requests", totalBlobSizeOnRequests).build();
    }

    @Override
    public void reset() {
        StreamSupport.stream(this.blobStoreManager.browse().spliterator(), false).forEach(BlobStore::clearOperationMetrics);
    }
}

