/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import com.sonatype.analytics.AnalyticsMarker;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.security.GpgUtils;

@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
@Named
@Singleton
public class AnalyticsYumGpg
extends ComponentSupport
implements AnalyticsMarker {
    private static final String CONFIG_KEY = "yumSigning";
    private static final String YUM_FORMAT = "yum";
    private final RepositoryManager repositoryManager;

    @Inject
    public AnalyticsYumGpg(RepositoryManager repositoryManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    @CachedGauge(name="nexus.analytics.yum_proxy_gpg_count", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public long countYumProxyGpg() {
        return this.countYumGpg("proxy");
    }

    @CachedGauge(name="nexus.analytics.yum_group_gpg_count", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public long countYumGroupGpg() {
        return this.countYumGpg("group");
    }

    private long countYumGpg(String type) {
        return this.getYumRepositories(type).stream().filter(this::isGpgRepository).count();
    }

    private boolean isGpgRepository(Repository repository) {
        ConfigurationFacet configurationFacet = (ConfigurationFacet)repository.facet(ConfigurationFacet.class);
        GpgUtils.SigningConfig config = (GpgUtils.SigningConfig)configurationFacet.readSection(repository.getConfiguration(), CONFIG_KEY, GpgUtils.SigningConfig.class);
        return GpgUtils.isConfigured((String)config.getKeypair(), (String)config.getPassphrase());
    }

    private List<Repository> getYumRepositories(String type) {
        return Streams.stream((Iterable)this.repositoryManager.browse()).filter(repo -> type.equals(repo.getType().getValue()) && YUM_FORMAT.equals(repo.getFormat().getValue())).collect(Collectors.toList());
    }
}

