/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sonatype.analytics.AnalyticsLicenseChecker;
import com.sonatype.analytics.AnalyticsMarker;
import com.sonatype.analytics.AnalyticsReportService;
import com.sonatype.analytics.AnalyticsScheduledReporter;
import com.sonatype.analytics.internal.AnalyticsReport;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class AnalyticsScheduledReporterImpl
extends StateGuardLifecycleSupport
implements AnalyticsScheduledReporter {
    public static final String NEXUS_ANALYTICS_PREFIX = "nexus.analytics.";
    @VisibleForTesting
    static final String COLLECTION_PERIOD_KEY = "collection_period_days";
    private final boolean enabled;
    private final TimeUnit startTimeUnit;
    private final long startPeriod;
    private String filterPrefix;
    private final boolean checkLicense;
    private final AnalyticsReportService reportService;
    private final AnalyticsLicenseChecker licenseChecker;
    private final MetricRegistry metricRegistry;
    private DateTime lastReportTime;
    private ScheduledReporter reporter;
    private List<AnalyticsMarker> analyticsMarkers;

    @Inject
    public AnalyticsScheduledReporterImpl(@Named(value="${nexus.analytics.scheduled.reporter.enabled:-true}") boolean enabled, @Named(value="${nexus.analytics.scheduled.reporter.timeUnit:-minutes}") String timeUnit, @Named(value="${nexus.analytics.scheduled.reporter.period:-1440}") long period, @Named(value="${nexus.analytics.scheduled.reporter.filterPrefix:-nexus.analytics.}") String filterPrefix, @Named(value="${nexus.analytics.scheduled.reporter.checkLicense:-true}") boolean checkLicense, AnalyticsReportService reportService, AnalyticsLicenseChecker licenseChecker, MetricRegistry metricRegistry, List<AnalyticsMarker> analyticsMarkers) {
        this.enabled = enabled;
        this.startTimeUnit = TimeUnit.valueOf(timeUnit.toUpperCase());
        this.startPeriod = period;
        this.filterPrefix = filterPrefix;
        this.checkLicense = checkLicense;
        this.reportService = (AnalyticsReportService)Preconditions.checkNotNull((Object)reportService);
        this.licenseChecker = (AnalyticsLicenseChecker)Preconditions.checkNotNull((Object)licenseChecker);
        this.metricRegistry = (MetricRegistry)Preconditions.checkNotNull((Object)metricRegistry);
        this.analyticsMarkers = (List)Preconditions.checkNotNull(analyticsMarkers);
    }

    @Override
    public boolean isStarted() {
        return super.isStarted() && Objects.nonNull(this.reporter);
    }

    @Override
    public boolean hasReported() {
        return Objects.nonNull(this.lastReportTime);
    }

    @Override
    public DateTime lastReportTime() {
        return this.lastReportTime;
    }

    @Override
    public void reportNow() {
        if (this.isStarted()) {
            this.log.info("Attempting to report analytics now (outside of schedule).");
            this.reporter.report();
        }
    }

    protected void doStart() {
        if (!this.enabled) {
            this.log.info("Analytics Scheduled Reporter was disabled at startup by configuration, not reporting analytics");
            return;
        }
        if (!this.startAnalyticsReportService()) {
            return;
        }
        this.startNexusScheduledReporter();
    }

    protected void doStop() {
        block9: {
            if (Objects.nonNull(this.reporter)) {
                try {
                    try {
                        this.reporter.stop();
                    }
                    catch (Exception e) {
                        this.log.info("Analytics Scheduled Reporter failed to stop properly.", (Throwable)(this.log.isDebugEnabled() ? e : null));
                        this.reporter = null;
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    this.reporter = null;
                    throw throwable;
                }
                this.reporter = null;
            }
        }
        if (Objects.nonNull(this.reportService)) {
            try {
                this.reportService.stop();
            }
            catch (Exception e) {
                this.log.info("AnalyticsReportService failed to stop properly.", (Throwable)(this.log.isDebugEnabled() ? e : null));
            }
        }
    }

    private boolean startAnalyticsReportService() {
        try {
            this.reportService.start();
            return true;
        }
        catch (Exception e) {
            this.log.info("AnalyticsReportService failed to start properly, not reporting analytics", (Throwable)(this.log.isDebugEnabled() ? e : null));
            return false;
        }
    }

    private boolean startNexusScheduledReporter() {
        try {
            this.reporter = new NexusScheduledReporter(this.metricRegistry, this.getClass().getName(), this.analyticsMarkers);
            this.reporter.start(this.startPeriod, this.startTimeUnit);
            return true;
        }
        catch (Exception e) {
            this.log.info("Analytics Scheduled Reporter failed to start properly, not reporting analytics", (Throwable)(this.log.isDebugEnabled() ? e : null));
            return false;
        }
    }

    private class NexusScheduledReporter
    extends ScheduledReporter {
        private final List<AnalyticsMarker> analyticsMarkers;

        private NexusScheduledReporter(MetricRegistry registry, String name, List<AnalyticsMarker> analyticsMarkers) {
            super(registry, name, StringUtils.isNotBlank((String)AnalyticsScheduledReporterImpl.this.filterPrefix) ? MetricFilter.startsWith((String)AnalyticsScheduledReporterImpl.this.filterPrefix) : MetricFilter.ALL, TimeUnit.SECONDS, TimeUnit.MILLISECONDS);
            this.analyticsMarkers = analyticsMarkers;
        }

        public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
            if (AnalyticsScheduledReporterImpl.this.checkLicense && !AnalyticsScheduledReporterImpl.this.licenseChecker.analyticsSubmissionAuthorized()) {
                return;
            }
            AnalyticsScheduledReporterImpl.this.log.info("Reporting Analytics");
            AnalyticsReport report = new AnalyticsReport();
            gauges.forEach((key, value) -> {
                if (!(value.getValue() instanceof Exception)) {
                    report.add((String)key, value.getValue());
                }
            });
            counters.forEach((key, counter) -> {
                Object object = report.add((String)key, counter.getCount());
            });
            histograms.forEach((key, histogram) -> {
                Object object = report.add((String)key, histogram.getCount());
            });
            meters.forEach((key, meter) -> {
                Object object = report.add((String)key, this.getMeterData((Meter)meter));
            });
            timers.forEach((key, timer) -> {
                Object object = report.add((String)key, timer.getCount());
            });
            if (report.hasValues()) {
                report.add(AnalyticsScheduledReporterImpl.COLLECTION_PERIOD_KEY, this.getPeriod());
                AnalyticsScheduledReporterImpl.this.reportService.report(report);
                AnalyticsScheduledReporterImpl.this.lastReportTime = DateTime.now();
                this.resetAnalytics();
            }
        }

        private long getPeriod() {
            long periodMillis = AnalyticsScheduledReporterImpl.this.lastReportTime != null ? DateTime.now().getMillis() - AnalyticsScheduledReporterImpl.this.lastReportTime.getMillis() : ManagementFactory.getRuntimeMXBean().getUptime();
            return Math.round((double)periodMillis / 1000.0 / 60.0 / 60.0 / 24.0);
        }

        private Map<String, Object> getMeterData(Meter meter) {
            return ImmutableMap.of((Object)"count", (Object)meter.getCount(), (Object)"requests_per_sec", (Object)meter.getMeanRate());
        }

        private void resetAnalytics() {
            this.analyticsMarkers.forEach(AnalyticsMarker::reset);
        }
    }
}

