/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.analytics.AnalyticsScheduledReporter;
import com.sonatype.analytics.internal.capability.AnalyticsCapability;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.capability.CapabilityContext;
import org.sonatype.nexus.capability.CapabilityEvent;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventAware;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class AnalyticsEnablementService
extends ComponentSupport
implements EventAware {
    private AnalyticsScheduledReporter service;

    @Inject
    public AnalyticsEnablementService(AnalyticsScheduledReporter service) {
        this.service = (AnalyticsScheduledReporter)Preconditions.checkNotNull((Object)service);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(CapabilityEvent.BeforePassivated event) {
        if (this.isRelevant((CapabilityEvent)event)) {
            this.stopService();
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(CapabilityEvent.AfterRemove event) {
        if (this.isRelevant((CapabilityEvent)event)) {
            this.stopService();
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(CapabilityEvent.AfterActivated event) {
        if (this.isRelevant((CapabilityEvent)event)) {
            this.maybeStartService((CapabilityEvent)event);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(CapabilityEvent.AfterUpdate event) {
        if (this.isRelevant((CapabilityEvent)event)) {
            this.maybeStartService((CapabilityEvent)event);
        }
    }

    private void maybeStartService(CapabilityEvent event) {
        CapabilityReference ref = event.getReference();
        CapabilityContext context = ref.context();
        if (context.isActive() && context.isEnabled() && ((AnalyticsCapability)ref.capabilityAs(AnalyticsCapability.class)).isSubmitEnabled()) {
            this.startService();
        } else {
            this.stopService();
        }
    }

    private void startService() {
        try {
            if (!this.service.isStarted()) {
                this.service.start();
            }
        }
        catch (Exception e) {
            this.log.debug("Failed to start analytics service", (Throwable)e);
        }
    }

    private boolean isRelevant(CapabilityEvent event) {
        return AnalyticsCapability.TYPE.equals((Object)event.getReference().context().type());
    }

    private void stopService() {
        try {
            if (this.service.isStarted()) {
                this.service.stop();
            }
        }
        catch (Exception e) {
            this.log.debug("Failed to stop analytics service", (Throwable)e);
        }
    }
}

