/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;

@Named
@Singleton
@Upgrades(model="usertoken", from="1.1", to="1.2")
@DependsOn(model="security", version="1.1", checkpoint=true)
public class UserTokenUpgrade_1_2
extends DatabaseUpgradeSupport {
    private static final String DB_CLASS = new OClassNameBuilder().prefix("usertoken").type("record").build();
    private static final String DROP_OLD_USERNAME_INDEX_QUERY = "DROP INDEX usertoken_record_username_idx";
    private static final String CREATE_NEW_USERNAME_INDEX_QUERY = String.format("CREATE INDEX usertoken_record_username_idx ON %s (username) NOTUNIQUE", DB_CLASS);
    private final Provider<DatabaseInstance> securityDatabaseInstance;

    @Inject
    public UserTokenUpgrade_1_2(@Named(value="security") Provider<DatabaseInstance> securityDatabaseInstance) {
        this.securityDatabaseInstance = (Provider)Preconditions.checkNotNull(securityDatabaseInstance);
    }

    public void apply() {
        UserTokenUpgrade_1_2.withDatabaseAndClass(this.securityDatabaseInstance, (String)DB_CLASS, (db, type) -> {
            db.command((OCommandRequest)new OCommandSQL(DROP_OLD_USERNAME_INDEX_QUERY)).execute(new Object[0]);
            db.command((OCommandRequest)new OCommandSQL(CREATE_NEW_USERNAME_INDEX_QUERY)).execute(new Object[0]);
        });
    }
}

