/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.store.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.sonatype.nexus.usertoken.plugin.UserToken;
import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.store.DuplicateUserTokenException;
import com.sonatype.nexus.usertoken.plugin.store.UserTokenStore;
import com.sonatype.nexus.usertoken.plugin.store.internal.orient.OrientUserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.store.internal.orient.OrientUserTokenRecordEntityAdapter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named(value="orient")
@Singleton
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
public class OrientUserTokenStore
extends StateGuardLifecycleSupport
implements UserTokenStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientUserTokenRecordEntityAdapter entityAdapter;

    @Inject
    public OrientUserTokenStore(@Named(value="security") Provider<DatabaseInstance> databaseInstance, OrientUserTokenRecordEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (OrientUserTokenRecordEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public void add(UserTokenRecord record) throws DuplicateUserTokenException {
        Preconditions.checkNotNull((Object)record);
        Preconditions.checkArgument((boolean)(record instanceof OrientUserTokenRecord), (Object)"UserTokenRecord is not appropriate for this backing store");
        try {
            OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
                ODocument oDocument = this.entityAdapter.addEntity(db, (Entity)((OrientUserTokenRecord)record));
            });
        }
        catch (ORecordDuplicatedException oRecordDuplicatedException) {
            throw new DuplicateUserTokenException(record.toString());
        }
    }

    @Override
    public void addOrReplace(UserTokenRecord record) {
        Preconditions.checkNotNull((Object)record);
        Preconditions.checkArgument((boolean)(record instanceof OrientUserTokenRecord), (Object)"UserTokenRecord is not appropriate for this backing store");
        OrientUserTokenRecord orientRecord = (OrientUserTokenRecord)record;
        OrientUserTokenRecord existingRecord = (OrientUserTokenRecord)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.get(db, record.getNameCode(), record.getPrincipals().getRealmNames()));
        if (existingRecord != null) {
            existingRecord.copy(orientRecord);
            OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
                ODocument oDocument = this.entityAdapter.editEntity(db, (Entity)existingRecord);
            });
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public void remove(String userName, String realm) {
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull((Object)realm);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            boolean bl = this.entityAdapter.deleteByUserNameAndRealm(db, userName, realm);
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public void remove(String userName, Set<String> realms) {
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull(realms);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            boolean bl = this.entityAdapter.deleteByUserNameAndRealm(db, userName, realms);
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public void remove(String nameCode) {
        Preconditions.checkNotNull((Object)nameCode);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            boolean bl = this.entityAdapter.deleteByNameCode(db, nameCode);
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public void removeWithUserId(String userName) {
        Preconditions.checkNotNull((Object)userName);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            boolean bl = this.entityAdapter.deleteByUserName(db, userName);
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean contains(String userName, String realm) {
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull((Object)realm);
        return (Boolean)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.contains(db, userName, realm));
    }

    @Override
    @Guarded(by={"STARTED"})
    public UserTokenRecord get(String userName, String realm) {
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull((Object)realm);
        return (UserTokenRecord)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.get(db, userName, realm));
    }

    @Override
    @Guarded(by={"STARTED"})
    public UserTokenRecord get(String userName, Set<String> realms) {
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull(realms);
        return (UserTokenRecord)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.get(db, userName, realms));
    }

    @Override
    public List<UserTokenRecord> get(@Nullable Date createdSince) {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> ImmutableList.copyOf(this.entityAdapter.get(db, createdSince)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public Collection<UserTokenRecord> records() {
        return (Collection)OrientTransactional.inTx(this.databaseInstance).call(db -> ImmutableList.copyOf(this.entityAdapter.getAll(db)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void clear() {
        OrientTransactional.inTxRetry(this.databaseInstance).run(this.entityAdapter::deleteAll);
    }

    @Override
    @Guarded(by={"STARTED"})
    public int size() {
        return (Integer)OrientTransactional.inTx(this.databaseInstance).call(db -> (int)this.entityAdapter.count(db));
    }

    @Override
    @Guarded(by={"STARTED"})
    public UserTokenRecord get(String nameCode) {
        Preconditions.checkNotNull((Object)nameCode);
        return (UserTokenRecord)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.get(db, nameCode));
    }

    @Override
    public UserTokenRecord newUserTokenRecord(PrincipalCollection principals, UserToken token, Date created) {
        return new OrientUserTokenRecord(principals, token, created);
    }
}

