/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.store.internal.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.usertoken.plugin.UserToken;
import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.internal.UserNameHelper;
import java.io.Serializable;
import java.util.Date;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.goodies.common.InternalAccessible;
import org.sonatype.nexus.common.entity.AbstractEntity;

public class OrientUserTokenRecord
extends AbstractEntity
implements Serializable,
UserTokenRecord {
    private PrincipalCollection principals;
    private UserToken userToken;
    private Date created;

    @InternalAccessible
    public OrientUserTokenRecord(PrincipalCollection principals, UserToken userToken, Date created) {
        this.principals = (PrincipalCollection)Preconditions.checkNotNull((Object)principals);
        this.userToken = (UserToken)Preconditions.checkNotNull((Object)userToken);
        this.created = (Date)Preconditions.checkNotNull((Object)created);
    }

    @Override
    public PrincipalCollection getPrincipals() {
        return this.principals;
    }

    @Override
    public String getUserName() {
        return UserNameHelper.get(this.getPrincipals()).toLowerCase();
    }

    @Override
    public UserToken getUserToken() {
        return this.userToken;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    public void copy(OrientUserTokenRecord other) {
        this.created = other.created;
        this.principals = other.principals;
        this.userToken = other.userToken;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "userName='" + this.getUserName() + '\'' + ", principals=" + this.principals + ", userToken=" + this.userToken + ", created=" + this.created + '}';
    }
}

