/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.store.internal;

import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.usertoken.plugin.UserToken;
import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.store.DuplicateUserTokenException;
import com.sonatype.nexus.usertoken.plugin.store.UserTokenStore;
import com.sonatype.nexus.usertoken.plugin.store.internal.UserTokenRecordDAO;
import com.sonatype.nexus.usertoken.plugin.store.internal.UserTokenRecordData;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.datastore.api.DuplicateKeyException;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class UserTokenStoreImpl
extends ConfigStoreSupport<UserTokenRecordDAO>
implements UserTokenStore {
    @Inject
    public UserTokenStoreImpl(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Override
    public UserTokenRecord newUserTokenRecord(PrincipalCollection principals, UserToken token, Date created) {
        return new UserTokenRecordData(principals, token, created);
    }

    @Override
    @Transactional
    public void add(UserTokenRecord record) throws DuplicateUserTokenException {
        try {
            ((UserTokenRecordDAO)this.dao()).insert((UserTokenRecordData)record);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            throw new DuplicateUserTokenException(record.toString());
        }
    }

    @Override
    @Transactional
    public void addOrReplace(UserTokenRecord record) {
        UserTokenRecordData userTokenRecordData = (UserTokenRecordData)record;
        UserTokenRecord existingToken = this.get(record.getUserName(), record.getPrincipals().getRealmNames());
        if (existingToken instanceof UserTokenRecordData) {
            UserTokenRecordData castedToken = (UserTokenRecordData)existingToken;
            castedToken.copy(userTokenRecordData);
            ((UserTokenRecordDAO)this.dao()).update(castedToken);
        } else {
            ((UserTokenRecordDAO)this.dao()).insert(userTokenRecordData);
        }
    }

    @Override
    @Transactional
    public boolean contains(String userName, String realm) {
        UserTokenRecord existingToken = this.get(userName, realm);
        return existingToken != null;
    }

    @Override
    @Transactional
    public List<UserTokenRecord> get(Date createdSince) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(createdSince == null ? ((UserTokenRecordDAO)this.dao()).browse().iterator() : ((UserTokenRecordDAO)this.dao()).browseByCreatedDate(createdSince).iterator(), 16), false).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public Collection<UserTokenRecord> records() {
        return ImmutableList.copyOf(((UserTokenRecordDAO)this.dao()).browse());
    }

    @Override
    @Transactional
    public UserTokenRecord get(String nameCode) {
        Optional<UserTokenRecordData> result = ((UserTokenRecordDAO)this.dao()).readByNameCode(nameCode);
        return result.isPresent() ? (UserTokenRecord)result.get() : null;
    }

    @Override
    @Transactional
    public UserTokenRecord get(String userName, String realm) {
        List<UserTokenRecordData> userTokens = ((UserTokenRecordDAO)this.dao()).readByUser(userName);
        Optional<UserTokenRecordData> result = userTokens.stream().filter(token -> token.getPrincipals().getRealmNames().contains(realm)).findFirst();
        return result.isPresent() ? (UserTokenRecord)result.get() : null;
    }

    @Override
    @Transactional
    public UserTokenRecord get(String userName, Set<String> realms) {
        List<UserTokenRecordData> userTokens = ((UserTokenRecordDAO)this.dao()).readByUser(userName);
        for (UserTokenRecord userTokenRecord : userTokens) {
            if (Collections.disjoint(userTokenRecord.getPrincipals().getRealmNames(), realms)) continue;
            return userTokenRecord;
        }
        return null;
    }

    @Override
    @Transactional
    public int size() {
        return ((UserTokenRecordDAO)this.dao()).count();
    }

    @Override
    public UserTokenRecord newUserTokenRecord(PrincipalCollection principals, UserToken token) {
        return new UserTokenRecordData(principals, token, new Date());
    }

    @Override
    @Transactional
    public void remove(String userName, String realm) {
        UserTokenRecord existingToken = this.get(userName, realm);
        if (existingToken != null) {
            ((UserTokenRecordDAO)this.dao()).deleteByNameCode(existingToken.getNameCode());
        }
    }

    @Override
    @Transactional
    public void remove(String userName, Set<String> realms) {
        UserTokenRecord existingToken = this.get(userName, realms);
        if (existingToken != null) {
            ((UserTokenRecordDAO)this.dao()).deleteByNameCode(existingToken.getNameCode());
        }
    }

    @Override
    @Transactional
    public void removeWithUserId(String userName) {
        ((UserTokenRecordDAO)this.dao()).deleteByUserName(userName);
    }

    @Override
    @Transactional
    public void remove(String nameCode) {
        ((UserTokenRecordDAO)this.dao()).deleteByNameCode(nameCode);
    }

    @Override
    @Transactional
    public void clear() {
        ((UserTokenRecordDAO)this.dao()).deleteAll();
    }
}

