/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.store;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.sonatype.nexus.usertoken.plugin.UserToken;
import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.store.DuplicateUserTokenException;
import com.sonatype.nexus.usertoken.plugin.store.TransientUserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.store.UserTokenStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;

@Named
@Singleton
@Priority(value=-2147483648)
public class TransientUserTokenStore
extends StateGuardLifecycleSupport
implements UserTokenStore {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, List<UserTokenRecord>> recordsByUserName = Maps.newHashMap();
    private final Map<String, UserTokenRecord> recordsByNameCode = Maps.newHashMap();

    @Override
    public void add(UserTokenRecord record) throws DuplicateUserTokenException {
        Preconditions.checkNotNull((Object)record);
        this.lock.readLock().lock();
        try {
            if (this.recordsByNameCode.containsKey(record.getNameCode())) {
                throw new DuplicateUserTokenException(record.toString());
            }
            if (this.recordsByUserName.containsKey(record.getUserName())) {
                this.recordsByUserName.get(record.getUserName().toLowerCase()).add(record);
            } else {
                this.addFirstRecordByUserName(record);
            }
            this.recordsByNameCode.put(record.getNameCode(), record);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void addOrReplace(UserTokenRecord record) {
        this.lock.readLock().lock();
        try {
            if (this.recordsByNameCode.containsKey(record.getNameCode())) {
                UserTokenRecord existingRecord = this.get(record.getUserName(), record.getPrincipals().getRealmNames());
                if (existingRecord == null) {
                    ArrayList<UserTokenRecord> records = new ArrayList<UserTokenRecord>();
                    records.add(record);
                    this.recordsByUserName.put(record.getUserName(), records);
                } else {
                    int index = this.recordsByUserName.get(record.getUserName().toLowerCase()).indexOf(existingRecord);
                    this.recordsByUserName.get(record.getUserName().toLowerCase()).set(index, record);
                }
            } else {
                this.addFirstRecordByUserName(record);
            }
            this.recordsByNameCode.put(record.getNameCode(), record);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void addFirstRecordByUserName(UserTokenRecord record) {
        ArrayList<UserTokenRecord> records = new ArrayList<UserTokenRecord>();
        records.add(record);
        this.recordsByUserName.put(record.getUserName(), records);
    }

    @Override
    public void remove(String userName, String realm) {
        Preconditions.checkNotNull((Object)userName);
        this.lock.writeLock().lock();
        try {
            this.removeExistingUserTokenRecord(this.get(userName, realm));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void remove(String userName, Set<String> realms) {
        this.lock.writeLock().lock();
        try {
            this.removeExistingUserTokenRecord(this.get(userName, realms));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void removeWithUserId(String userName) {
        Preconditions.checkNotNull((Object)userName);
        this.lock.writeLock().lock();
        try {
            List<UserTokenRecord> records = this.recordsByUserName.get(userName.toLowerCase());
            if (records != null && !records.isEmpty()) {
                for (UserTokenRecord record : records) {
                    this.recordsByNameCode.remove(record.getNameCode());
                }
            }
            this.recordsByUserName.remove(userName.toLowerCase());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void remove(String nameCode) {
        Preconditions.checkNotNull((Object)nameCode);
        this.lock.writeLock().lock();
        try {
            this.removeExistingUserTokenRecord(this.get(nameCode));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void removeExistingUserTokenRecord(UserTokenRecord existingRecord) {
        if (existingRecord != null) {
            this.recordsByNameCode.remove(existingRecord.getNameCode());
            List<UserTokenRecord> existingUserRecords = this.recordsByUserName.get(existingRecord.getUserName().toLowerCase());
            int indexToRemove = existingUserRecords.indexOf(existingRecord);
            if (indexToRemove >= 0) {
                existingUserRecords.remove(indexToRemove);
                if (existingUserRecords.isEmpty()) {
                    this.recordsByUserName.remove(existingRecord.getUserName().toLowerCase());
                }
            }
        }
    }

    @Override
    public boolean contains(String userName, String realm) {
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull((Object)realm);
        this.lock.readLock().lock();
        try {
            UserTokenRecord existingRecord = this.get(userName, realm);
            boolean bl = existingRecord != null;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<UserTokenRecord> get(Date createdSince) {
        this.lock.readLock().lock();
        try {
            List<UserTokenRecord> list = this.records().stream().filter(userTokenRecord -> createdSince == null || userTokenRecord.getCreated().after(createdSince)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.recordsByUserName.clear();
            this.recordsByNameCode.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.recordsByUserName.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<UserTokenRecord> records() {
        this.lock.readLock().lock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf(this.recordsByNameCode.values());
            return immutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public UserTokenRecord get(String userName, String realm) {
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull((Object)realm);
        this.lock.readLock().lock();
        try {
            List<UserTokenRecord> records = this.recordsByUserName.get(userName.toLowerCase());
            if (records != null && !records.isEmpty()) {
                UserTokenRecord userTokenRecord = records.stream().filter(token -> token.getPrincipals().getRealmNames().contains(realm)).findFirst().orElse(null);
                return userTokenRecord;
            }
            return null;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public UserTokenRecord get(String userName, Set<String> realms) {
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull(realms);
        this.lock.readLock().lock();
        try {
            List<UserTokenRecord> records = this.recordsByUserName.get(userName.toLowerCase());
            if (records != null && !records.isEmpty()) {
                for (UserTokenRecord record : records) {
                    if (Collections.disjoint(record.getPrincipals().getRealmNames(), realms)) continue;
                    UserTokenRecord userTokenRecord = record;
                    return userTokenRecord;
                }
            }
            return null;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public UserTokenRecord get(String nameCode) {
        return this.recordsByNameCode.get(nameCode);
    }

    @Override
    public UserTokenRecord newUserTokenRecord(PrincipalCollection principals, UserToken token, Date created) {
        return new TransientUserTokenRecord(principals, token, created);
    }
}

