/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.rest.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.usertoken.plugin.UserTokenService;
import com.sonatype.nexus.usertoken.plugin.rest.internal.resources.doc.UserTokenApiResourceDoc;
import io.swagger.annotations.ApiOperation;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.security.user.UserNotFoundException;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class UserTokenApiResource
extends ComponentSupport
implements Resource,
UserTokenApiResourceDoc {
    private final UserTokenService userTokenService;
    private final SecuritySystem securitySystem;

    @Inject
    public UserTokenApiResource(UserTokenService userTokenService, SecuritySystem securitySystem) {
        this.userTokenService = (UserTokenService)Preconditions.checkNotNull((Object)userTokenService);
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull((Object)securitySystem);
    }

    @Override
    @DELETE
    @Path(value="{userId}/{realm}/user-token-reset")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:usertoken-user:delete"})
    public void reset(@NotNull @PathParam(value="userId") String userId, @NotNull @PathParam(value="realm") String realm) {
        this.checkIfUserTokenServiceIsEnabled();
        try {
            this.securitySystem.getUser(userId);
        }
        catch (UserNotFoundException unfe) {
            this.handleUserNotFound(userId, unfe);
        }
        this.userTokenService.remove(userId, realm);
    }

    @DELETE
    @Path(value="{userId}/user-token")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:usertoken-user:delete"})
    @ApiOperation(hidden=true, value="Deprecated")
    public void reset(@NotNull @PathParam(value="userId") String userId) {
        this.checkIfUserTokenServiceIsEnabled();
        try {
            this.securitySystem.getUser(userId);
        }
        catch (UserNotFoundException unfe) {
            this.handleUserNotFound(userId, unfe);
        }
        this.userTokenService.removeWithUserId(userId);
    }

    private void checkIfUserTokenServiceIsEnabled() {
        if (!this.userTokenService.isEnabled()) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)"\"User tokens are not enabled.\"", "application/json");
        }
    }

    private void handleUserNotFound(String userId, UserNotFoundException unfe) {
        this.log.debug("Unable to locate userId: {}", (Object)userId, (Object)unfe);
        throw new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)("\"User '" + userId + "' not found.\""), "application/json");
    }
}

