/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.internal.ui;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.UserTokenService;
import com.sonatype.nexus.usertoken.plugin.rest.model.SettingsXO;
import com.sonatype.nexus.usertoken.plugin.rest.model.UserTokenStatusXO;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.ref.SoftReference;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.sonatype.nexus.common.wonderland.AuthTicketService;
import org.sonatype.nexus.extdirect.DirectComponentSupport;
import org.sonatype.nexus.security.authz.AuthorizationManager;
import org.sonatype.nexus.validation.Validate;

@Named
@Singleton
@DirectAction(action={"usertoken_UserToken"})
public class UserTokenComponent
extends DirectComponentSupport
implements GroovyObject {
    @Inject
    private Map<String, AuthorizationManager> availableAuthorizationManagers;
    @Inject
    private UserTokenService userTokens;
    @Inject
    private AuthTicketService authTokens;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public UserTokenComponent() {
        MetaClass metaClass;
        CallSite[] callSiteArray = UserTokenComponent.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:usertoken-settings:read"})
    public SettingsXO read() {
        CallSite[] callSiteArray = UserTokenComponent.$getCallSiteArray();
        return (SettingsXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callConstructor(SettingsXO.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"enabled", callSiteArray[1].callGetProperty((Object)this.userTokens), "protectContent", callSiteArray[2].callGetProperty((Object)this.userTokens), "realmConfigured", callSiteArray[3].callGetProperty((Object)this.userTokens)})), SettingsXO.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @Validate
    @RequiresPermissions(value={"nexus:usertoken-settings:update"})
    public SettingsXO update(@NotNull SettingsXO settingsXO) {
        CallSite[] callSiteArray = UserTokenComponent.$getCallSiteArray();
        Object object = callSiteArray[4].callGetProperty((Object)settingsXO);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)this.userTokens, (String)"enabled");
        Object object2 = callSiteArray[5].callGetProperty((Object)settingsXO);
        ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)this.userTokens, (String)"protectContent");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (SettingsXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].callCurrent((GroovyObject)this), SettingsXO.class);
        }
        return this.read();
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:usertoken-users:delete"})
    @Validate
    public void resetAll(@NotEmpty String authToken) {
        CallSite[] callSiteArray = UserTokenComponent.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[7].callCurrent((GroovyObject)this, (Object)authToken);
        } else {
            this.validateAuthToken(authToken);
        }
        callSiteArray[8].call((Object)this.userTokens);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:usertoken-user:read"})
    @Validate
    public UserTokenStatusXO status(@NotEmpty String authToken, @NotEmpty String userName, @NotEmpty String source) {
        CallSite[] callSiteArray = UserTokenComponent.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[9].callCurrent((GroovyObject)this, (Object)authToken);
        } else {
            this.validateAuthToken(authToken);
        }
        UserTokenRecord record = (UserTokenRecord)ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].call((Object)this.userTokens, (Object)userName, callSiteArray[11].call(callSiteArray[12].call(this.availableAuthorizationManagers, (Object)source))), UserTokenRecord.class);
        UserTokenStatusXO status = (UserTokenStatusXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].callConstructor(UserTokenStatusXO.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"provisioned", ScriptBytecodeAdapter.compareNotEqual((Object)record, null)})), UserTokenStatusXO.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)record)) {
            Object object = callSiteArray[14].callGetProperty((Object)record);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)status, (String)"created");
        }
        return status;
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:usertoken-user:delete"})
    @Validate
    public void reset(@NotEmpty String authToken, @NotEmpty String userName, @NotEmpty String source) {
        CallSite[] callSiteArray = UserTokenComponent.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[15].callCurrent((GroovyObject)this, (Object)authToken);
        } else {
            this.validateAuthToken(authToken);
        }
        callSiteArray[16].call((Object)this.userTokens, (Object)userName, callSiteArray[17].call(callSiteArray[18].call(this.availableAuthorizationManagers, (Object)source)));
    }

    public void validateAuthToken(String authToken) {
        CallSite[] callSiteArray = UserTokenComponent.$getCallSiteArray();
        callSiteArray[19].callStatic(Preconditions.class, (Object)authToken);
        callSiteArray[20].call(callSiteArray[21].callGroovyObjectGetProperty((Object)this), (Object)"Validating authentication ticket: {}", (Object)authToken);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[22].call((Object)this.authTokens, (Object)authToken))) {
            throw (Throwable)callSiteArray[23].callConstructor(IllegalAccessException.class, (Object)"Invalid authentication ticket");
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != UserTokenComponent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public Map<String, AuthorizationManager> getAvailableAuthorizationManagers() {
        return this.availableAuthorizationManagers;
    }

    public void setAvailableAuthorizationManagers(Map<String, AuthorizationManager> map) {
        this.availableAuthorizationManagers = map;
    }

    public UserTokenService getUserTokens() {
        return this.userTokens;
    }

    public void setUserTokens(UserTokenService userTokenService) {
        this.userTokens = userTokenService;
    }

    public AuthTicketService getAuthTokens() {
        return this.authTokens;
    }

    public void setAuthTokens(AuthTicketService authTicketService) {
        this.authTokens = authTicketService;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "enabled";
        stringArray[2] = "protectContent";
        stringArray[3] = "realmConfigured";
        stringArray[4] = "enabled";
        stringArray[5] = "protectContent";
        stringArray[6] = "read";
        stringArray[7] = "validateAuthToken";
        stringArray[8] = "removeAll";
        stringArray[9] = "validateAuthToken";
        stringArray[10] = "get";
        stringArray[11] = "getRealmName";
        stringArray[12] = "get";
        stringArray[13] = "<$constructor$>";
        stringArray[14] = "created";
        stringArray[15] = "validateAuthToken";
        stringArray[16] = "remove";
        stringArray[17] = "getRealmName";
        stringArray[18] = "get";
        stringArray[19] = "checkNotNull";
        stringArray[20] = "debug";
        stringArray[21] = "log";
        stringArray[22] = "redeemTicket";
        stringArray[23] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[24];
        UserTokenComponent.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(UserTokenComponent.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = UserTokenComponent.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

