/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.sonatype.nexus.usertoken.plugin.UserToken;
import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.UserTokenService;
import com.sonatype.nexus.usertoken.plugin.encoding.EncodingStrategy;
import com.sonatype.nexus.usertoken.plugin.encoding.NameCodeGenerator;
import com.sonatype.nexus.usertoken.plugin.encoding.PassCodeGenerator;
import com.sonatype.nexus.usertoken.plugin.internal.UserNameHelper;
import com.sonatype.nexus.usertoken.plugin.internal.UserTokenCapabilityConfiguration;
import com.sonatype.nexus.usertoken.plugin.internal.UserTokenCapabilityDescriptor;
import com.sonatype.nexus.usertoken.plugin.rest.model.exportimport.UserTokenRecordXO;
import com.sonatype.nexus.usertoken.plugin.store.DuplicateUserTokenException;
import com.sonatype.nexus.usertoken.plugin.store.UserTokenStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.sonatype.nexus.capability.CapabilityContext;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.crypto.CryptoHelper;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.security.UserPrincipalsHelper;
import org.sonatype.nexus.security.realm.RealmConfiguration;
import org.sonatype.nexus.security.realm.RealmManager;
import org.sonatype.nexus.security.user.UserNotFoundException;

@Named
@Singleton
public class UserTokenServiceImpl
extends StateGuardLifecycleSupport
implements UserTokenService {
    private static final String CPREFIX = "${usertoken.userTokenServiceImpl";
    private final SecurityHelper securityHelper;
    private final RealmManager realmManager;
    private final UserPrincipalsHelper principalsHelper;
    private final UserTokenStore store;
    private final SecureRandom random;
    private final CapabilityRegistry capabilities;
    private final Provider<EncodingStrategy> encodingStrategy;
    private final NameCodeGenerator nameCodeGenerator;
    private final PassCodeGenerator passCodeGenerator;
    private final int maximumUniqueNameCodeAttempts;
    private AtomicBoolean protectContent = new AtomicBoolean(false);

    @Inject
    public UserTokenServiceImpl(SecurityHelper securityHelper, RealmManager realmManager, UserPrincipalsHelper principalsHelper, CryptoHelper crypto, CapabilityRegistry capabilities, UserTokenStore store, Provider<EncodingStrategy> encodingStrategy, NameCodeGenerator nameCodeGenerator, PassCodeGenerator passCodeGenerator, @Named(value="${usertoken.userTokenServiceImpl.maximumUniqueNameCodeAttempts:-10}") int maximumUniqueNameCodeAttempts) {
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
        this.realmManager = (RealmManager)Preconditions.checkNotNull((Object)realmManager);
        this.principalsHelper = (UserPrincipalsHelper)Preconditions.checkNotNull((Object)principalsHelper);
        this.capabilities = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilities);
        this.store = (UserTokenStore)Preconditions.checkNotNull((Object)store);
        this.random = ((CryptoHelper)Preconditions.checkNotNull((Object)crypto)).createSecureRandom();
        this.encodingStrategy = (Provider)Preconditions.checkNotNull(encodingStrategy);
        this.nameCodeGenerator = (NameCodeGenerator)Preconditions.checkNotNull((Object)nameCodeGenerator);
        this.passCodeGenerator = (PassCodeGenerator)Preconditions.checkNotNull((Object)passCodeGenerator);
        Preconditions.checkArgument((maximumUniqueNameCodeAttempts > 0 ? 1 : 0) != 0);
        this.maximumUniqueNameCodeAttempts = maximumUniqueNameCodeAttempts;
        this.log.debug("Maximum unique name-code attempts: {}", (Object)maximumUniqueNameCodeAttempts);
    }

    private CapabilityReference capabilityReference() {
        Collection refs = this.capabilities.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(UserTokenCapabilityDescriptor.TYPE));
        Preconditions.checkState((!refs.isEmpty() ? 1 : 0) != 0, (Object)"User-token capability has been removed");
        return (CapabilityReference)refs.iterator().next();
    }

    @Override
    public boolean isEnabled() {
        return this.capabilities.get(this.capabilityReference().context().id()).context().isEnabled();
    }

    @Override
    public void setEnabled(boolean enable) {
        this.log.debug("Enabled: {}", (Object)enable);
        try {
            if (enable) {
                this.capabilities.enable(this.capabilityReference().context().id());
            } else {
                this.capabilities.disable(this.capabilityReference().context().id());
            }
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void ensureEnabled() {
        Preconditions.checkState((boolean)this.isEnabled(), (Object)"User-token feature is not enabled");
    }

    @Override
    public boolean isProtectContent() {
        return this.protectContent.get();
    }

    @Override
    public void setProtectContent(boolean enable) {
        if (this.isProtectContent() != enable) {
            CapabilityContext cctx = this.capabilityReference().context();
            UserTokenCapabilityConfiguration config = new UserTokenCapabilityConfiguration(cctx.properties());
            config.setProtectContent(enable);
            try {
                this.capabilities.update(cctx.id(), cctx.isEnabled(), cctx.notes(), config.asMap());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean isRealmConfigured() {
        return this.realmManager.isRealmEnabled("User-Token-Realm");
    }

    private void maybeConfigureRealm() throws Exception {
        if (!this.realmManager.isRealmEnabled("User-Token-Realm")) {
            RealmConfiguration config = this.realmManager.getConfiguration();
            ArrayList realmNames = Lists.newArrayListWithCapacity((int)(config.getRealmNames().size() + 1));
            realmNames.add("User-Token-Realm");
            realmNames.addAll(config.getRealmNames());
            config.setRealmNames((List)realmNames);
            this.realmManager.setConfiguration(config);
        }
    }

    @Override
    public EncodingStrategy getEncodingStrategy() {
        return (EncodingStrategy)this.encodingStrategy.get();
    }

    @Override
    public int getRecordCount() {
        return this.store.size();
    }

    protected void doStart() throws Exception {
        if (!EventHelper.isReplicating()) {
            this.maybeConfigureRealm();
        }
        UserTokenCapabilityConfiguration config = new UserTokenCapabilityConfiguration(this.capabilityReference().context().properties());
        this.log.debug("Protect content: {}", (Object)config.isProtectContent());
        this.protectContent.set(config.isProtectContent());
    }

    protected void doStop() throws Exception {
        this.protectContent.set(false);
    }

    @Override
    public UserTokenRecord get(String nameCode) {
        Preconditions.checkNotNull((Object)nameCode);
        this.ensureEnabled();
        this.log.debug("Looking up record for: {}", (Object)nameCode);
        UserTokenRecord record = this.store.get(nameCode);
        this.log.debug("Record: {}", (Object)record);
        return record;
    }

    @Override
    public UserTokenRecord current(boolean create) {
        this.ensureEnabled();
        PrincipalCollection principals = this.securityHelper.subject().getPrincipals();
        String userName = UserNameHelper.get(principals);
        UserTokenRecord record = this.doGet(userName, principals.getRealmNames());
        if (record == null && create) {
            record = this.create(principals);
        }
        return record;
    }

    @Override
    public UserTokenRecord get(String userName, String realm) {
        this.ensureEnabled();
        return this.doGet(userName, realm);
    }

    @Override
    public List<UserTokenRecord> get(@Nullable Date since) {
        this.ensureEnabled();
        return this.store.get(since);
    }

    private UserTokenRecord doGet(String userName, String realm) {
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull((Object)realm);
        this.log.debug("Getting record for: {} and realm {}", (Object)userName, (Object)realm);
        return this.store.get(userName, realm);
    }

    private UserTokenRecord doGet(String userName, Set<String> realms) {
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull(realms);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting record for: {} and any of the realms {}", (Object)userName, (Object)String.join((CharSequence)",", realms));
        }
        return this.store.get(userName, realms);
    }

    private String createNameCode(String userName) {
        try {
            String tmp = String.valueOf(userName) + "#" + this.random.nextLong();
            return this.nameCodeGenerator.generate((EncodingStrategy)this.encodingStrategy.get(), tmp);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private char[] createPassCode() {
        try {
            return this.passCodeGenerator.generate((EncodingStrategy)this.encodingStrategy.get());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public UserTokenRecord create(PrincipalCollection principals) {
        Preconditions.checkNotNull((Object)principals);
        this.ensureEnabled();
        this.log.debug("Creating user-token record for: {}", (Object)principals);
        char[] passCode = this.createPassCode();
        String userName = UserNameHelper.get(principals);
        int count = 0;
        while (true) {
            String nameCode = this.createNameCode(userName);
            try {
                UserToken token = new UserToken(nameCode, passCode);
                UserTokenRecord record = this.store.newUserTokenRecord(principals, token);
                this.store.add(record);
                this.log.debug("Added record mapping: {} -> {}", (Object)userName, (Object)nameCode);
                return record;
            }
            catch (DuplicateUserTokenException duplicateUserTokenException) {
                Preconditions.checkState((++count <= this.maximumUniqueNameCodeAttempts ? 1 : 0) != 0, (String)"Failed to create user-token record; giving up after %s attempts", (int)count);
                this.log.debug("Detected name-code collision for '{}'; retrying", (Object)nameCode);
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            break;
        }
    }

    @Override
    public void insert(UserTokenRecordXO userTokenRecordXO, boolean overwrite) throws DuplicateUserTokenException {
        UserToken token = new UserToken(userTokenRecordXO.getNameCode(), userTokenRecordXO.getPassCode());
        SimplePrincipalCollection principals = new SimplePrincipalCollection();
        userTokenRecordXO.getPrincipalCollection().keySet().forEach(realmName -> userTokenRecordXO.getPrincipalCollection().get(realmName).forEach(principal -> principals.add(principal, realmName)));
        UserTokenRecord record = this.store.newUserTokenRecord((PrincipalCollection)principals, token, userTokenRecordXO.getCreated());
        if (overwrite) {
            this.store.addOrReplace(record);
            this.log.debug("Added/replaced usertoken record for principal {}", (Object)record.getUserName());
        } else {
            this.store.add(record);
            this.log.debug("Added usertoken record for principal {}", (Object)record.getUserName());
        }
    }

    @Override
    public void remove(String userName, String realm) {
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull((Object)realm);
        this.ensureEnabled();
        this.log.debug("Removing record for: {} and source {}", (Object)userName, (Object)realm);
        this.store.remove(userName, realm);
    }

    @Override
    public void remove(String userName, Set<String> realms) {
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull(realms);
        this.ensureEnabled();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing record for: userId {} and realms {}", (Object)userName, (Object)String.join((CharSequence)",", realms));
        }
        this.store.remove(userName, realms);
    }

    @Override
    public void remove(String nameCode) {
        Preconditions.checkNotNull((Object)nameCode);
        this.ensureEnabled();
        this.log.debug("Removing record for: {}", (Object)nameCode);
        this.store.remove(nameCode);
    }

    @Override
    public void removeWithUserId(String userId) {
        Preconditions.checkNotNull((Object)userId);
        this.ensureEnabled();
        this.log.debug("Removing record for: UserId {} in all realms", (Object)userId);
        this.store.removeWithUserId(userId);
    }

    @Override
    public void removeAll() {
        this.log.info("Removing all records");
        this.ensureEnabled();
        this.store.clear();
    }

    @Override
    public void removeInvalid() {
        this.log.debug("Removing invalid records");
        this.ensureEnabled();
        int count = 0;
        for (UserTokenRecord record : this.store.records()) {
            try {
                this.principalsHelper.getUserStatus(record.getPrincipals());
            }
            catch (UserNotFoundException userNotFoundException) {
                this.remove(record.getUserName(), record.getPrincipals().getRealmNames());
                ++count;
            }
        }
        this.log.debug("Removed {} invalid records", (Object)count);
    }
}

