/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.sonatype.nexus.usertoken.plugin.UserTokenService;
import com.sonatype.nexus.usertoken.plugin.realm.UserTokenRealm;
import eu.bitwalker.useragentutils.Browser;
import eu.bitwalker.useragentutils.BrowserType;
import eu.bitwalker.useragentutils.UserAgent;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.handlers.ContributedHandler;
import org.sonatype.nexus.security.anonymous.AnonymousManager;
import org.sonatype.nexus.security.token.BearerTokenRealm;

@Named
@Singleton
public class UserTokenHandler
extends ComponentSupport
implements ContributedHandler {
    private static final String BASIC_AUTH_SCHEME = "BASIC";
    private static final String AUTH_MESSAGE = "Content access is protected by token";
    private final UserTokenService userTokenService;
    private final AnonymousManager anonymousManager;

    @Inject
    public UserTokenHandler(UserTokenService userTokenService, AnonymousManager anonymousManager) {
        this.userTokenService = (UserTokenService)Preconditions.checkNotNull((Object)userTokenService);
        this.anonymousManager = (AnonymousManager)Preconditions.checkNotNull((Object)anonymousManager);
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        String userAgent;
        if (this.userTokenService.isProtectContent() && this.restrictedUserAgent(userAgent = context.getRequest().getHeaders().get("User-Agent")) && !this.isValidAnonymousRequest(context) && !UserTokenHandler.wasTokenAuth(context, BearerTokenRealm.IS_TOKEN_AUTH_KEY) && !UserTokenHandler.wasTokenAuth(context, UserTokenRealm.IS_TOKEN_AUTH_KEY)) {
            return HttpResponses.unauthorized((String)AUTH_MESSAGE, (String)BASIC_AUTH_SCHEME, (String)"User-Token-Realm");
        }
        return context.proceed();
    }

    private boolean isValidAnonymousRequest(Context context) {
        return UserTokenHandler.notAuthRequest(context) && this.anonymousManager.isEnabled();
    }

    private static boolean notAuthRequest(Context context) {
        return context.getRequest().getHeaders().get("Authorization") == null;
    }

    private static boolean wasTokenAuth(Context context, String tokenAuthKey) {
        Object flag = context.getRequest().getAttributes().get(tokenAuthKey);
        return flag != null && flag instanceof Boolean ? (Boolean)flag : false;
    }

    @VisibleForTesting
    boolean restrictedUserAgent(String userAgentHeader) {
        if (Strings.isNullOrEmpty((String)userAgentHeader)) {
            return true;
        }
        UserAgent userAgent = UserAgent.parseUserAgentString((String)userAgentHeader);
        Browser browser = userAgent.getBrowser();
        BrowserType browserType = browser.getBrowserType();
        this.log.debug("User-agent: {}, Browser: {}, Browser-type: {}", new Object[]{userAgentHeader, browser, browserType});
        switch (browser) {
            case BOT: 
            case DOWNLOAD: 
            case UNKNOWN: {
                return true;
            }
        }
        return this.checkBrowserType(browserType);
    }

    private boolean checkBrowserType(BrowserType browserType) {
        switch (browserType) {
            case WEB_BROWSER: 
            case MOBILE_BROWSER: 
            case TEXT_BROWSER: {
                return false;
            }
        }
        return true;
    }
}

