/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.usertoken.plugin.UserTokenService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.security.UserPrincipalsExpired;

@Named
@Singleton
public class UserTokenEventInspector
extends ComponentSupport
implements EventAware {
    private final UserTokenService userTokens;

    @Inject
    public UserTokenEventInspector(UserTokenService userTokens) {
        this.userTokens = (UserTokenService)Preconditions.checkNotNull((Object)userTokens);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(UserPrincipalsExpired event) {
        if (this.userTokens.isEnabled()) {
            String userId = event.getUserId();
            if (userId != null) {
                this.userTokens.remove(userId, event.getSource());
            } else {
                this.userTokens.removeInvalid();
            }
        }
    }
}

