/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.sonatype.nexus.capability.CapabilityConfigurationSupport;

public class UserTokenCapabilityConfiguration
extends CapabilityConfigurationSupport {
    public static final String PROTECT_CONTENT = "protectContent";
    public static final boolean DEFAULT_PROTECT_CONTENT = false;
    private boolean protectContent;

    public UserTokenCapabilityConfiguration(Map<String, String> properties) {
        Preconditions.checkNotNull(properties);
        this.protectContent = this.parseBoolean(properties.get(PROTECT_CONTENT), false);
    }

    public boolean isProtectContent() {
        return this.protectContent;
    }

    public UserTokenCapabilityConfiguration setProtectContent(boolean protectContent) {
        this.protectContent = protectContent;
        return this;
    }

    public Map<String, String> asMap() {
        HashMap props = Maps.newHashMap();
        props.put(PROTECT_CONTENT, String.valueOf(this.protectContent));
        return props;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "protectContent=" + this.protectContent + '}';
    }
}

