/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.licensing.ext.capability.LicensingConditions;
import com.sonatype.nexus.usertoken.plugin.internal.UserTokenCapabilityConfiguration;
import com.sonatype.nexus.usertoken.plugin.internal.UserTokenFeature;
import com.sonatype.nexus.usertoken.plugin.internal.UserTokenServiceImpl;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.nexus.capability.CapabilitySupport;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.common.template.TemplateParameters;

@Named(value="usertoken")
public class UserTokenCapability
extends CapabilitySupport<UserTokenCapabilityConfiguration> {
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final LicensingConditions licensingConditions;
    private final UserTokenServiceImpl userTokens;
    private final UserTokenFeature feature;

    @Inject
    public UserTokenCapability(LicensingConditions licensingConditions, UserTokenServiceImpl userTokens, UserTokenFeature feature) {
        this.licensingConditions = (LicensingConditions)Preconditions.checkNotNull((Object)licensingConditions);
        this.userTokens = (UserTokenServiceImpl)Preconditions.checkNotNull((Object)userTokens);
        this.feature = (UserTokenFeature)((Object)Preconditions.checkNotNull((Object)((Object)feature)));
    }

    protected UserTokenCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new UserTokenCapabilityConfiguration(properties);
    }

    protected void onActivate(UserTokenCapabilityConfiguration config) throws Exception {
        this.userTokens.start();
    }

    protected void onPassivate(UserTokenCapabilityConfiguration config) throws Exception {
        this.userTokens.stop();
    }

    public Condition activationCondition() {
        return this.conditions().logical().and(new Condition[]{this.licensingConditions.licenseIsValid((Feature)this.feature), this.conditions().capabilities().passivateCapabilityDuringUpdate()});
    }

    protected String renderDescription() throws Exception {
        if (this.context().isActive()) {
            return messages.description(this.userTokens.getRecordCount());
        }
        return null;
    }

    protected String renderStatus() throws Exception {
        if (!this.context().isActive()) {
            return null;
        }
        return this.render("usertoken-status.vm", new TemplateParameters().set("service", (Object)this.userTokens));
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Records: %s")
        public String description(int var1);
    }
}

