/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.datastore;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

@Named
@Singleton
public class UserTokenUpgrade_1_6
extends ComponentSupport
implements DatabaseMigrationStep {
    private static final String TABLE_NAME = "USER_TOKEN";
    private static final String VERSION = "1.6";
    private static final String STATEMENT = "ALTER TABLE user_token DROP CONSTRAINT IF EXISTS pk_user_token_user_name;ALTER TABLE user_token DROP CONSTRAINT IF EXISTS pk_user_token_name_code;ALTER TABLE user_token DROP CONSTRAINT IF EXISTS uk_user_token_name_code;ALTER TABLE user_token ADD CONSTRAINT pk_user_token_name_code PRIMARY KEY (name_code);CREATE INDEX IF NOT EXISTS idx_user_token_user_name ON user_token(user_name);";

    public Optional<String> version() {
        return Optional.of(VERSION);
    }

    public void migrate(Connection connection) throws Exception {
        if (!this.tableExists(connection, TABLE_NAME)) {
            this.log.info("Table {} does not exists. Upgrade step will be ignored.", (Object)TABLE_NAME);
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement stmt = connection.createStatement();){
            stmt.executeUpdate(STATEMENT);
            this.log.info("Table schema of {} has been updated. Database schema updated to {}", (Object)TABLE_NAME, (Object)VERSION);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

