/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.api;

import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.UserTokenService;
import com.sonatype.nexus.usertoken.plugin.api.UserTokensImportExportApiResourceDoc;
import com.sonatype.nexus.usertoken.plugin.rest.model.exportimport.UserTokenRecordXO;
import com.sonatype.nexus.usertoken.plugin.store.DuplicateUserTokenException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.crypto.PbeCipherFactory;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/v1/security/user-tokens")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@FeatureFlag(name="nexus.usertoken.restapi.enabled")
public class UserTokensImportExportApiResourceV1
extends ComponentSupport
implements Resource,
UserTokensImportExportApiResourceDoc {
    public static final String RESOURCE_URI = "/v1/security/user-tokens";
    private static final String CIPHER_SALT = "677275646765686f6c646572";
    private static final String CIPHER_IV = "0123456789ABCDEF";
    private final UserTokenService userTokenService;
    private final PbeCipherFactory pbeCipherFactory;

    @Inject
    public UserTokensImportExportApiResourceV1(UserTokenService userTokenService, PbeCipherFactory pbeCipherFactory) {
        this.userTokenService = userTokenService;
        this.pbeCipherFactory = pbeCipherFactory;
    }

    @Override
    @GET
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    @Path(value="/export")
    public List<UserTokenRecordXO> exportTokens(@QueryParam(value="since") Long since, @QueryParam(value="encryptionPassword") String encryptionPassword) {
        try {
            PbeCipherFactory.PbeCipher cipher = this.createCipher(encryptionPassword);
            Date querySince = since == null ? null : new Date(since);
            return this.userTokenService.get(querySince).stream().map(userTokenRecord -> this.fromUserTokenRecord((UserTokenRecord)userTokenRecord, cipher)).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.log.warn("Failed to export tokens, {}", (Object)e.getMessage(), (Object)e);
            return Collections.emptyList();
        }
    }

    @Override
    @POST
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    @Path(value="/import")
    public Response importTokens(List<UserTokenRecordXO> userTokenRecordXOs, @QueryParam(value="decryptionPassword") String decryptionPassword, @QueryParam(value="overwrite") boolean overwrite) {
        ArrayList failedUserTokens = new ArrayList();
        try {
            PbeCipherFactory.PbeCipher cipher = this.createCipher(decryptionPassword);
            userTokenRecordXOs.forEach(userTokenRecordXO -> {
                String decNameCode = new String(cipher.decrypt(Base64.getDecoder().decode(userTokenRecordXO.getNameCode())), StandardCharsets.UTF_8);
                String decPassCode = new String(cipher.decrypt(Base64.getDecoder().decode(userTokenRecordXO.getPassCode())), StandardCharsets.UTF_8);
                userTokenRecordXO.setNameCode(decNameCode);
                userTokenRecordXO.setPassCode(decPassCode);
                try {
                    this.userTokenService.insert((UserTokenRecordXO)userTokenRecordXO, overwrite);
                }
                catch (DuplicateUserTokenException duplicateUserTokenException) {
                    this.log.warn("overwrite is not enabled, and a duplicate record was found, will skip {}", userTokenRecordXO.getPrincipalCollection());
                    failedUserTokens.add(userTokenRecordXO.getPrincipalCollection().toString());
                }
                catch (Exception e) {
                    this.log.warn("Failed to import {}", userTokenRecordXO.getPrincipalCollection(), (Object)e);
                    failedUserTokens.add(userTokenRecordXO.getPrincipalCollection().toString());
                }
            });
            return Response.ok().entity(failedUserTokens).build();
        }
        catch (Exception e) {
            this.log.warn("Failed to import tokens, {}", (Object)e.getMessage(), (Object)e);
            return Response.serverError().entity((Object)"Import tokens failed, see logs for details.").build();
        }
    }

    private UserTokenRecordXO fromUserTokenRecord(UserTokenRecord userTokenRecord, PbeCipherFactory.PbeCipher cipher) {
        String encNameCode = new String(Base64.getEncoder().encode(cipher.encrypt(userTokenRecord.getNameCode().getBytes(StandardCharsets.UTF_8))), StandardCharsets.UTF_8);
        String encPassCode = new String(Base64.getEncoder().encode(cipher.encrypt(new String(userTokenRecord.getPassCode()).getBytes(StandardCharsets.UTF_8))), StandardCharsets.UTF_8);
        return new UserTokenRecordXO().withCreated(userTokenRecord.getCreated()).withNameCode(encNameCode).withPassCode(encPassCode).withPrincipalCollection(userTokenRecord.getPrincipals().getRealmNames().stream().collect(Collectors.toMap(realmName -> realmName, realmName -> ImmutableList.copyOf((Collection)userTokenRecord.getPrincipals().fromRealm(realmName)))));
    }

    private PbeCipherFactory.PbeCipher createCipher(String password) throws Exception {
        return this.pbeCipherFactory.create(password, CIPHER_SALT, CIPHER_IV);
    }
}

