/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.api;

import com.sonatype.nexus.usertoken.plugin.rest.model.exportimport.UserTokenRecordXO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.ws.rs.core.Response;

@Api(value="Security management: user tokens")
public interface UserTokensImportExportApiResourceDoc {
    @ApiOperation(value="Export user tokens to a file", notes="Keep track of the password used, as it must also be used when importing this data back into NXRM.")
    @ApiResponses(value={@ApiResponse(code=200, message="User token successfully exported"), @ApiResponse(code=400, message="User tokens are not enabled"), @ApiResponse(code=403, message="Insufficient permissions to export user tokens")})
    public List<UserTokenRecordXO> exportTokens(@ApiParam(value="Long value representing epoch time, all records newer than this timestamp will be return") Long var1, @ApiParam(value="String that will be used as a password for encrypting the name/key code values (this same password will be required when attempting to import this file", required=true) String var2);

    @ApiOperation(value="Import user tokens from a file", notes="Must use same password that was used during export for proper decryption of name/pass codes.")
    @ApiResponses(value={@ApiResponse(code=200, message="User token successfully imported, see response entity for tokens that were not imported."), @ApiResponse(code=400, message="User tokens are not enabled"), @ApiResponse(code=403, message="Insufficient permissions to import user tokens")})
    public Response importTokens(@ApiParam(value="List of objects to be imported", required=true) List<UserTokenRecordXO> var1, @ApiParam(value="String that will be used as a password for decrypting the name/key code values before import", required=true) String var2, @ApiParam(value="Flag stating whether to overwrite existing records", defaultValue="false") boolean var3);
}

