/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher.integration;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.runtime.beans.actions.update.ShutdownCallingLauncherAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.macos.MacAuthorization;
import com.install4j.runtime.installer.platform.macos.VolumeInfo;
import com.install4j.runtime.launcher.Launcher;
import com.install4j.runtime.launcher.LauncherVariables;
import com.install4j.runtime.launcher.integration.LockFile;
import com.install4j.runtime.launcher.integration.SingleBundleUpdater;
import com.install4j.runtime.launcher.integration.UpdateConfig;
import com.install4j.runtime.launcher.integration.UpdateExecutionConfig;
import com.install4j.runtime.launcher.util.SingleInstance;
import com.install4j.runtime.util.Base64;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class AutomaticUpdate {
    private static final int RETRY_INHIBITION = Integer.getInteger("install4j.updateRetryInhibition", 1440);
    private static final String PROPNAME_UPDATE_DIR = "install4j.updateStorageDir";
    private static volatile File updateDir;

    public static File getUpdateDir() {
        if (updateDir == null) {
            String updateDirName = System.getProperty(PROPNAME_UPDATE_DIR);
            if (updateDirName != null) {
                updateDir = new File(updateDirName);
            } else {
                String applicationId = AutomaticUpdate.getApplicationId();
                if (applicationId == null) {
                    applicationId = "unknown";
                }
                updateDir = new File(new File(new File(InstallerVariables.getInstall4jCacheDir(), "update"), Base64.encodeForFiles(applicationId)), SingleInstance.getPathHash(ResourceHelper.getRuntimeDir(), ""));
            }
        }
        return updateDir;
    }

    public static boolean isScheduled(final String version, final boolean checkTimeInhibition) {
        final boolean[] ret = new boolean[1];
        UpdateConfig.withConfig(false, new UpdateConfig.ConfigConsumer(){

            @Override
            public boolean handleConfig(UpdateConfig updateConfig) throws IOException {
                ret[0] = !(version != null && !version.equals(updateConfig.getVersion()) || !AutomaticUpdate.shouldBeExecuted(updateConfig) || checkTimeInhibition && !AutomaticUpdate.isNoTimeInhibition(updateConfig));
                return false;
            }
        });
        return ret[0];
    }

    private static boolean shouldBeExecuted(UpdateConfig updateConfig) {
        String fileName = updateConfig.getFile();
        return !updateConfig.isSuccess() && updateConfig.getTryCount() < updateConfig.getMaxTries() && updateConfig.getCancelCount() < updateConfig.getMaxCancelCount() && fileName != null && !fileName.isEmpty() && new File(fileName).exists();
    }

    public static void checkUpdates(String[] launcherArguments, final UpdateExecutionConfig updateExecutionConfig, boolean restartLauncher, Runnable shutdownRunnable) {
        if (UpdateConfig.getConfigFile().isFile()) {
            UpdateConfig.withConfig(false, new UpdateConfig.ConfigConsumer(){

                @Override
                public boolean handleConfig(UpdateConfig updateConfig) throws IOException {
                    String fileName = updateConfig.getFile();
                    String version = updateConfig.getVersion();
                    if (!fileName.isEmpty() && !version.isEmpty()) {
                        if (AutomaticUpdate.shouldBeExecuted(updateConfig)) {
                            String applicationVersion;
                            if (AutomaticUpdate.isNoTimeInhibition(updateConfig) && !Objects.equals(version, applicationVersion = LauncherVariables.getApplicationVersion())) {
                                updateExecutionConfig.setInstallerFile(new File(fileName));
                                updateExecutionConfig.setLanguageId(updateConfig.getLanguageId());
                                updateExecutionConfig.setInstallationDirectory(updateConfig.getInstallationDirectory());
                                updateExecutionConfig.getArguments().addAll(updateConfig.getArguments());
                                updateConfig.setTryCount(updateConfig.getTryCount() + 1);
                                updateConfig.setInstallTimestamp(System.currentTimeMillis());
                                return true;
                            }
                        } else if (AutomaticUpdate.isNoTimeInhibition(updateConfig) || updateConfig.isSuccess()) {
                            boolean tryDelete = true;
                            if (Util.isMacOS() && fileName.endsWith(".dmg")) {
                                for (Map.Entry<String, String> entry : VolumeInfo.getMountPointToDiskFile().entrySet()) {
                                    if (!Objects.equals(fileName, entry.getValue()) || VolumeInfo.detach(new File(entry.getKey()))) continue;
                                    tryDelete = false;
                                }
                            }
                            if (tryDelete) {
                                File file = new File(fileName);
                                file.delete();
                                if (!file.isFile()) {
                                    updateConfig.clear();
                                    return true;
                                }
                            }
                        }
                    }
                    return false;
                }
            });
            if (updateExecutionConfig.getInstallerFile() != null && updateExecutionConfig.getInstallerFile().exists()) {
                if (updateExecutionConfig.getUnattendedUpdateTitle() != null && !updateExecutionConfig.getUnattendedUpdateTitle().isEmpty()) {
                    LauncherVariables.setLanguageId(updateExecutionConfig.getLanguageId());
                    updateExecutionConfig.setUnattendedUpdateTitle(LauncherVariables.replaceVariables(updateExecutionConfig.getUnattendedUpdateTitle()));
                }
                try {
                    AutomaticUpdate.doUpdate(updateExecutionConfig, restartLauncher, shutdownRunnable, launcherArguments);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static boolean isNoTimeInhibition(UpdateConfig updateConfig) {
        return System.currentTimeMillis() > updateConfig.getInstallTimestamp() + TimeUnit.MINUTES.toMillis(RETRY_INHIBITION);
    }

    private static void doUpdate(UpdateExecutionConfig updateExecutionConfig, boolean restartLauncher, Runnable shutdownRunnable, String[] launcherArguments) throws IOException, MacAuthorization.BaseAuthorizationException {
        Context context = ContextImpl.getCurrentContext();
        if (context != null) {
            ShutdownCallingLauncherAction.shutdownCallingLauncher(context, true, 120);
        }
        if (!AutomaticUpdate.handleMacosArchive(updateExecutionConfig, restartLauncher, launcherArguments)) {
            AutomaticUpdate.executeInstaller(updateExecutionConfig, restartLauncher, launcherArguments);
        }
        if (shutdownRunnable != null) {
            shutdownRunnable.run();
        } else {
            if (context != null) {
                context.finish(0);
            }
            System.exit(0);
        }
    }

    private static boolean isAdminWritable(File file) {
        try {
            Path path = file.toPath();
            Set<PosixFilePermission> posixFilePermissions = Files.getPosixFilePermissions(path, new LinkOption[0]);
            return posixFilePermissions.contains((Object)PosixFilePermission.OTHERS_WRITE) || posixFilePermissions.contains((Object)PosixFilePermission.GROUP_WRITE) && Files.readAttributes(path, PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS).group().getName().equals("admin") || Files.getOwner(path, LinkOption.NOFOLLOW_LINKS).getName().equals(System.getProperty("user.name")) && posixFilePermissions.contains((Object)PosixFilePermission.OWNER_WRITE);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean handleMacosArchive(UpdateExecutionConfig updateExecutionConfig, boolean restartLauncher, String[] launcherArguments) throws IOException, MacAuthorization.BaseAuthorizationException {
        if (Util.isMacOS() && updateExecutionConfig.getInstallerFile().isDirectory()) {
            File[] files = updateExecutionConfig.getInstallerFile().listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && pathname.getName().endsWith(".app");
                }
            });
            if (files != null && files.length == 1) {
                File sourceAppDir = files[0];
                String installationDirectory = updateExecutionConfig.getInstallationDirectory();
                boolean authorize = false;
                if (Boolean.getBoolean("install4j.backgroundUpdateAdmin")) {
                    authorize = true;
                } else if (!installationDirectory.startsWith(System.getProperty("user.home"))) {
                    if (Util.isAdminGroup()) {
                        File destinationBundle = new File(installationDirectory, sourceAppDir.getName());
                        authorize = !AutomaticUpdate.isAdminWritable(AutomaticUpdate.getCurrentSingleBundle()) || destinationBundle.exists() && !AutomaticUpdate.isAdminWritable(destinationBundle) || !AutomaticUpdate.isAdminWritable(new File(installationDirectory));
                    } else {
                        authorize = true;
                    }
                }
                ArrayList<String> arguments = new ArrayList<String>();
                arguments.add("-classpath");
                arguments.add(new File(ResourceHelper.getRuntimeDir(), "i4jruntime.jar").getAbsolutePath());
                LockFile.addLockFile(arguments);
                arguments.add(SingleBundleUpdater.class.getName());
                arguments.add(sourceAppDir.getAbsolutePath());
                arguments.add(installationDirectory);
                arguments.add(String.valueOf(restartLauncher));
                if (launcherArguments != null) {
                    arguments.addAll(Arrays.asList(launcherArguments));
                }
                File executable = new File(System.getProperty("java.home"), "bin/java");
                if (authorize) {
                    MacAuthorization.execute(MacAuthorization.getDefaultPrompt(AutomaticUpdate.getApplicationName()), executable.getAbsolutePath(), arguments);
                } else {
                    LaunchHelper.launchApplication(new LaunchDescriptor(executable).arguments(arguments).wait(false));
                }
            }
            return true;
        }
        return false;
    }

    private static void executeInstaller(UpdateExecutionConfig updateExecutionConfig, boolean restartLauncher, String[] launcherArguments) {
        LaunchDescriptor launchDescriptor = new LaunchDescriptor(updateExecutionConfig.getInstallerFile());
        launchDescriptor.arguments(AutomaticUpdate.getInstallerArguments(updateExecutionConfig, restartLauncher, launcherArguments));
        launchDescriptor.specificEnvironmentVariables(Collections.singletonMap("INSTALL4J_JAVA_HOME", System.getProperty("java.home")));
        launchDescriptor.attachWithNoBrowse(true);
        launchDescriptor.useNohup(!Util.isWindows() && !Util.isMacOS());
        LaunchHelper.launchApplication(launchDescriptor);
    }

    private static List<String> getInstallerArguments(UpdateExecutionConfig updateExecutionConfig, boolean restartLauncher, String[] launcherArguments) {
        String launchInfoPath;
        ArrayList<String> arguments = new ArrayList<String>();
        if (updateExecutionConfig.getExecutionMode() != null) {
            arguments.addAll(updateExecutionConfig.getExecutionMode().getArguments(updateExecutionConfig.getUnattendedUpdateTitle()));
        }
        arguments.addAll(updateExecutionConfig.getArguments());
        if (updateExecutionConfig.getLanguageId() != null && !updateExecutionConfig.getLanguageId().isEmpty()) {
            arguments.add("-Duser.language=" + updateExecutionConfig.getLanguageId());
            arguments.add("-Dinstall4j.language=" + updateExecutionConfig.getLanguageId());
        }
        if (updateExecutionConfig.getInstallationDirectory() != null && !updateExecutionConfig.getInstallationDirectory().isEmpty()) {
            arguments.add("-dir");
            arguments.add(updateExecutionConfig.getInstallationDirectory());
        }
        if (restartLauncher && (launchInfoPath = AutomaticUpdate.getLaunchInfoPath(launcherArguments)) != null) {
            arguments.add("-Dinstall4j.launchInfoFile=" + launchInfoPath);
        }
        LockFile.addLockFile(arguments);
        arguments.add("-Dinstall4j.updateStorageDir=" + AutomaticUpdate.getUpdateDir());
        arguments.add("-Vsys.automaticUpdate=true");
        return arguments;
    }

    public static File getCurrentSingleBundle() {
        File runtimeDir;
        if (Util.isMacOS() && (runtimeDir = ResourceHelper.getRuntimeDir()) != null) {
            File installationDir = runtimeDir.getParentFile();
            String dirName = FileUtil.getCanonicalPath(installationDir);
            if (dirName.toLowerCase(Locale.ENGLISH).endsWith("Contents/Resources/app".toLowerCase(Locale.ENGLISH))) {
                return new File(dirName.substring(0, dirName.length() - "Contents/Resources/app".length()));
            }
            if (dirName.toLowerCase(Locale.ENGLISH).endsWith("Contents/java/app".toLowerCase(Locale.ENGLISH))) {
                return new File(dirName.substring(0, dirName.length() - "Contents/java/app".length()));
            }
        }
        return null;
    }

    private static String getLaunchInfoPath(String[] launcherArguments) {
        String launcherPath = null;
        if (ContextImpl.getCurrentContext() == null || InstallerUtil.isInProcess()) {
            if (!Launcher.isService()) {
                launcherPath = System.getProperty("exe4j.moduleName");
            }
        } else if (!Boolean.getBoolean("install4j.fromService")) {
            launcherPath = System.getProperty("install4j.fromLauncher");
        }
        String launchInfoPath = null;
        if (launcherPath != null) {
            try {
                File launchInfoFile = File.createTempFile("launch", ".tmp", AutomaticUpdate.getUpdateDir());
                try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(launchInfoFile)), StandardCharsets.UTF_8));){
                    pw.println(launcherPath);
                    if (launcherArguments != null) {
                        for (String launcherArgument : launcherArguments) {
                            pw.println(launcherArgument);
                        }
                    }
                }
                launchInfoPath = launchInfoFile.getAbsolutePath();
            }
            catch (IOException e) {
                e.printStackTrace();
                launchInfoPath = null;
            }
        }
        return launchInfoPath;
    }

    private static String getApplicationId() {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (installerConfig == null) {
            try {
                return LauncherVariables.getApplicationId();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return installerConfig.getApplicationId();
    }

    public static String getApplicationName() {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (installerConfig == null) {
            try {
                return LauncherVariables.getApplicationName();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return installerConfig.getApplicationName();
    }

    public static void checkAutoUpdateLauncher() {
        File launchInfoFile;
        String launchInfoName;
        if (InstallerVariables.getBooleanVariable("sys.automaticUpdate") && (launchInfoName = System.getProperty("install4j.launchInfoFile")) != null && (launchInfoFile = new File(launchInfoName)).isFile()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(launchInfoFile), StandardCharsets.UTF_8));
                ArrayList<String> arguments = new ArrayList<String>();
                String executableName = reader.readLine();
                if (executableName != null) {
                    File executableFile = new File(executableName);
                    if (executableFile.exists()) {
                        String argument = reader.readLine();
                        while (argument != null) {
                            arguments.add(argument);
                            argument = reader.readLine();
                        }
                    }
                    LaunchHelper.launchFinishExecutable(executableFile, arguments.toArray(new String[0]), executableFile.getParentFile());
                }
            }
            catch (IOException e) {
                Logger.getInstance().log(e);
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!launchInfoFile.delete()) {
                launchInfoFile.deleteOnExit();
            }
        }
    }

    public static void checkRegularExit(final boolean success, final boolean cancelling) {
        if (success || cancelling) {
            UpdateConfig.withConfig(false, new UpdateConfig.ConfigConsumer(){

                @Override
                public boolean handleConfig(UpdateConfig updateConfig) throws IOException {
                    if (success) {
                        updateConfig.setSuccess(true);
                    } else if (cancelling) {
                        int cancelCount = updateConfig.getCancelCount();
                        updateConfig.setCancelCount(cancelCount + 1);
                        if (cancelCount < updateConfig.getMaxCancelCount()) {
                            updateConfig.setTryCount(updateConfig.getTryCount() - 1);
                        }
                    }
                    return true;
                }
            });
        }
    }
}

