/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.api.ProcessInfo;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.InstallationProperties;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.RunningProcessesDialog;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchStringAction;
import com.install4j.runtime.installer.helper.console.ConsoleImpl;
import com.install4j.runtime.installer.platform.macos.MacProcessHelper;
import com.install4j.runtime.installer.platform.win32.Misc;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class RunningProcessChecker {
    public static final int CLOSE_STRATEGY_NONE = 0;
    public static final int CLOSE_STRATEGY_ASK_ONLY = 1;
    public static final int CLOSE_STRATEGY_ASK_FOR_CLOSE = 2;
    public static final int CLOSE_STRATEGY_ASK_FOR_CLOSE_AND_TERMINATE = 3;
    public static final int CLOSE_STRATEGY_ASK_FOR_TERMINATE = 4;
    public static final int CLOSE_STRATEGY_CLOSE = 5;
    public static final int CLOSE_STRATEGY_TERMINATE = 6;
    private static boolean defaultChecked = false;

    public static boolean areInstalledLaunchersRunning() {
        try {
            return !RunningProcessChecker.checkRunningProcessesInt(RunningProcessChecker.getLauncherFileNames(), null, 0, 0, false);
        }
        catch (UserCanceledException userCanceledException) {
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
        }
        return false;
    }

    public static boolean checkDefaultRunningLauncher(String messageKey) throws UserCanceledException {
        if (Boolean.getBoolean("install4j.dontCheckProcesses")) {
            return true;
        }
        if (RunningProcessChecker.isPlatformSupported() || defaultChecked) {
            return true;
        }
        VariableResourceBundleWrapper messages = Messages.getMessages();
        String message = messageKey == null ? null : Messages.format(messages.getString(messageKey), "install4j", InstallerConfig.getCurrentInstance().getApplicationName());
        try {
            defaultChecked = RunningProcessChecker.checkRunningProcessesInt(RunningProcessChecker.getLauncherFileNames(), message, 1, 0, false);
            return defaultChecked;
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
            return true;
        }
    }

    public static boolean checkRunningProcesses(String message, int closeStrategy, int timeOut, boolean allowIgnore, boolean includeLaunchers, File[] additionalFiles) throws UserCanceledException {
        if (RunningProcessChecker.isPlatformSupported()) {
            return true;
        }
        HashSet<String> fileNames = new HashSet<String>();
        try {
            if (includeLaunchers) {
                fileNames.addAll(RunningProcessChecker.getLauncherFileNames());
            }
            if (additionalFiles != null) {
                for (File additionalFile : additionalFiles) {
                    if (additionalFile.isAbsolute()) {
                        fileNames.add(additionalFile.getCanonicalPath());
                        continue;
                    }
                    fileNames.add(additionalFile.getName());
                }
            }
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
        }
        boolean notRunning = RunningProcessChecker.checkRunningProcessesInt(fileNames, message, closeStrategy, timeOut, allowIgnore);
        if (includeLaunchers && notRunning) {
            defaultChecked = true;
        }
        return notRunning;
    }

    private static boolean checkRunningProcessesInt(Set<String> fileNames, String message, int closeStrategy, int wmCloseTimeout, boolean allowIgnore) throws UserCanceledException {
        boolean firstTime = true;
        Collection<ProcessInfo> running;
        while ((running = RunningProcessChecker.getRunningProcesses(fileNames)).size() != 0) {
            String result;
            if (closeStrategy == 0) {
                return false;
            }
            if (closeStrategy == 5) {
                return RunningProcessChecker.closeProcesses(false, wmCloseTimeout, running);
            }
            if (closeStrategy == 6) {
                return RunningProcessChecker.closeProcesses(true, wmCloseTimeout, running);
            }
            if (InstallerUtil.isUnattended() && !Boolean.getBoolean("install4j.unattendedShowRunningProcessDialog")) {
                if (message != null) {
                    ConsoleImpl.getInstance().println(Messages.getMessages().getString("UnattendedRunningFailure"));
                }
                return false;
            }
            if (message == null) {
                return false;
            }
            TreeSet<String> processNames = new TreeSet<String>();
            for (ProcessInfo processInfo : running) {
                String windowTitle = processInfo.getWindowTitle();
                if (windowTitle != null && windowTitle.trim().length() > 0 && !windowTitle.equals("Default IME") && !windowTitle.equals("theAwtToolkitWindow")) {
                    processNames.add(windowTitle);
                    continue;
                }
                processNames.add(new File(processInfo.getModuleName()).getAbsolutePath());
            }
            VariableResourceBundleWrapper messages = Messages.getMessages();
            ArrayList<String> buttonTexts = new ArrayList<String>();
            switch (closeStrategy) {
                case 2: {
                    buttonTexts.add(messages.getString("ButtonCloseProcesses"));
                    break;
                }
                case 3: {
                    buttonTexts.add(messages.getString(firstTime ? "ButtonCloseProcesses" : "ButtonTerminateProcesses"));
                    break;
                }
                case 4: {
                    buttonTexts.add(messages.getString("ButtonTerminateProcesses"));
                }
            }
            buttonTexts.add(messages.getString("ButtonRetry"));
            if (allowIgnore) {
                buttonTexts.add(messages.getString("ButtonIgnore"));
            }
            if ((result = RunningProcessChecker.showDialog(message, processNames, buttonTexts)) == null) {
                return false;
            }
            if (Objects.equals(result, messages.getString("ButtonIgnore"))) {
                return true;
            }
            if (Objects.equals(result, messages.getString("ButtonTerminateProcesses")) ? RunningProcessChecker.closeProcesses(true, wmCloseTimeout, running) : Objects.equals(result, messages.getString("ButtonCloseProcesses")) && RunningProcessChecker.closeProcesses(false, wmCloseTimeout, running)) {
                return true;
            }
            firstTime = false;
        }
        return true;
    }

    private static String showDialog(final String message, final Collection<String> processNames, final List<String> buttonTexts) throws UserCanceledException {
        if (InstallerUtil.isConsole()) {
            ConsoleImpl console = ConsoleImpl.getInstance();
            console.println(message);
            console.println();
            for (String processName : processNames) {
                console.println("* " + processName);
            }
            console.println();
            String[] options = buttonTexts.toArray(new String[0]);
            return options[console.askOption(null, options, null)];
        }
        return HelperCommunication.getInstance().fetchString(ExecutionContext.UNELEVATED, new FetchStringAction(){

            @Override
            protected String fetchValue(Context context) throws Exception {
                RunningProcessesDialog runningProcessesDialog = new RunningProcessesDialog(Util.getParentWindow(), message, processNames, buttonTexts);
                runningProcessesDialog.setVisible(true);
                if (runningProcessesDialog.isCanceled()) {
                    return null;
                }
                return (String)buttonTexts.get(runningProcessesDialog.getSelectedButtonIndex());
            }
        });
    }

    private static boolean closeProcesses(final boolean force, final int wmCloseTimeout, Collection<ProcessInfo> running) {
        final int[] ids = new int[running.size()];
        int i = 0;
        for (ProcessInfo processInfo : running) {
            ids[i++] = processInfo.getProcessId();
        }
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.MAXIMUM, new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context) throws Exception {
                if (Util.isWindows()) {
                    return Misc.terminateProcesses(ids, force, wmCloseTimeout) == 1;
                }
                if (Util.isMacOS()) {
                    return MacProcessHelper.terminateProcesses(ids, force, wmCloseTimeout == 0 ? 5000 : wmCloseTimeout);
                }
                return false;
            }
        });
    }

    private static Set<String> getLauncherFileNames() throws IOException {
        ContextInt context = ContextImpl.getContextInt(ContextImpl.getSingleContextInt());
        InstallationProperties installationProperties = context.getInstallationProperties();
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        Set<String> launcherFiles = installationProperties.getCanonicalPathPropertySet("launcher");
        if (Util.isMacosInstaller() && config.getMacSpecificConfig().isSingleBundle()) {
            String singleBundleName = config.getMacSpecificConfig().getSingleBundleName();
            singleBundleName = singleBundleName.substring(0, singleBundleName.length() - ".app".length());
            launcherFiles.add(new File(context.getInstallationDirectory(), RunningProcessChecker.getLauncherExecutable(singleBundleName)).getCanonicalPath());
        } else if (!(context instanceof UninstallerContext)) {
            String path = new File(context.getInstallationDirectory(), RunningProcessChecker.getLauncherExecutable(config.getUninstallerPath())).getCanonicalPath();
            launcherFiles.add(path);
        }
        return launcherFiles;
    }

    private static String getLauncherExecutable(String launcherPath) {
        if (Util.isWindows()) {
            return launcherPath + ".exe";
        }
        if (Util.isMacOS()) {
            return launcherPath + ".app/Contents/MacOS/" + "JavaApplicationStub";
        }
        return launcherPath;
    }

    private static Collection<ProcessInfo> getRunningProcesses(Set<String> fileNames) {
        HashSet<ProcessInfo> ret = new HashSet<ProcessInfo>();
        RunningProcessChecker.checkModules(ret, fileNames, HelperCommunication.getInstance().fetchObject(ExecutionContext.SAME, new GetModulesRemoteCallable()));
        if (HelperCommunication.getInstance().isConnected() && Util.isWindows()) {
            RunningProcessChecker.checkModules(ret, fileNames, HelperCommunication.getInstance().fetchObject(ExecutionContext.OTHER, new GetModulesRemoteCallable()));
        }
        return ret;
    }

    public static Collection<ProcessInfo> getAllRunningProcesses() {
        return RunningProcessChecker.getRunningProcesses(null);
    }

    private static void checkModules(Collection<ProcessInfo> ret, Set<String> fileNames, ProcessInfo[] processInfos) {
        if (processInfos == null) {
            return;
        }
        if (fileNames == null) {
            ret.addAll(Arrays.asList(processInfos));
        } else {
            for (ProcessInfo module : processInfos) {
                File file;
                try {
                    file = new File(module.getModuleName()).getCanonicalFile();
                }
                catch (IOException e) {
                    continue;
                }
                if (!fileNames.contains(file.getAbsolutePath()) && !fileNames.contains(file.getName())) continue;
                ret.add(module);
            }
        }
    }

    private static boolean isPlatformSupported() {
        if (InstallerUtil.isMacOS() && Boolean.getBoolean("install4j.disableMacosProcessCheck")) {
            return false;
        }
        return !InstallerUtil.isWindows() && !InstallerUtil.isMacOS();
    }

    private static class RunningProcessThread
    extends Thread {
        private ProcessInfo[] processInfos = null;

        public RunningProcessThread() {
            super("running-process-thread");
            this.setDaemon(true);
            this.setPriority(3);
        }

        public ProcessInfo[] getProcessInfos() {
            return this.processInfos;
        }

        @Override
        public void run() {
            this.processInfos = Util.isWindows() ? Misc.getRunningProcesses() : (Util.isMacOS() ? MacProcessHelper.getRunningProcesses() : new ProcessInfo[0]);
        }
    }

    private static class GetModulesRemoteCallable
    extends FetchObjectAction<ProcessInfo[]> {
        private GetModulesRemoteCallable() {
        }

        @Override
        protected ProcessInfo[] fetchValue(Context context) throws Exception {
            RunningProcessThread runningProcessThread = new RunningProcessThread();
            runningProcessThread.start();
            try {
                runningProcessThread.join(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (runningProcessThread.isAlive()) {
                runningProcessThread.stop();
            }
            return runningProcessThread.getProcessInfos();
        }
    }
}

