/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.repository.migrators.orient.OrientRepositoryMigratorSupport;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.orient.OrientRubygemsContentFacet;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="rubygems")
public class RubygemsRepositoryMigrator
extends OrientRepositoryMigratorSupport {
    @Override
    @Nullable
    protected Asset recordMetadata(StorageTx tx, RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        return null;
    }

    @Override
    protected void delete(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        RubygemsFile rubygemsFile = this.getRubygemsFile(this.nx2PathToNx3(change));
        if (rubygemsFile != null) {
            OrientRubygemsContentFacet facet = (OrientRubygemsContentFacet)this.getRepository().facet(OrientRubygemsContentFacet.class);
            this.inStorageTx(() -> {
                facet.delete(rubygemsFile);
                return null;
            });
        }
    }

    @Override
    protected void streamContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        RubygemsFile rubygemsFile = this.getRubygemsFile(this.getAssetName(change));
        if (rubygemsFile == null) {
            return;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = this.getTempBlob(change);){
            if (tempBlob == null) {
                return;
            }
            OrientRubygemsContentFacet rubygemsContentFacet = (OrientRubygemsContentFacet)this.getRepository().facet(OrientRubygemsContentFacet.class);
            this.inStorageTx(() -> {
                rubygemsContentFacet.putRubygemsFile(rubygemsFile, tempBlob, this.getContentType(change), new AttributesMap(Collections.singletonMap("last_modified", this.getLastUpdated(change))));
                return null;
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void hardLinkContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        RubygemsFile rubygemsFile = this.getRubygemsFile(this.getAssetName(change));
        if (rubygemsFile != null) {
            OrientRubygemsContentFacet rubygemsContentFacet = (OrientRubygemsContentFacet)this.getRepository().facet(OrientRubygemsContentFacet.class);
            this.inStorageTx(() -> {
                rubygemsContentFacet.putRubygemsFile(rubygemsFile, this.getStoragePath(change), this.getContentType(change), null, this.getHashCodes(change), this.getSize(change));
                return null;
            });
        }
    }

    @Override
    @Nullable
    protected Asset getIngestedContent(StorageTx tx, RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        RubygemsFile rubygemsFile = this.getRubygemsFile(this.getAssetName(change));
        if (rubygemsFile == null) {
            return null;
        }
        return tx.findAssetWithProperty("name", (Object)rubygemsFile.getPath(), tx.findBucket(this.getRepository()));
    }

    @Override
    public List<HashAlgorithm> getRequiredHashAlgorithms() {
        return Arrays.asList(HashAlgorithm.MD5, HashAlgorithm.SHA1);
    }

    @Override
    protected String getAssetName(RepositoryChangelogClient.ChangeEntryXO change) {
        return String.valueOf('/') + super.getAssetName(change);
    }

    protected String nx2PathToNx3(RepositoryChangelogClient.ChangeEntryXO change) {
        String path = (String)Preconditions.checkNotNull((Object)change.getChange().getPath());
        if (path.endsWith(".gem")) {
            return "gems" + path.substring(path.lastIndexOf(47));
        }
        return path;
    }

    @Nullable
    private RubygemsFile getRubygemsFile(String path) {
        RubygemsFile rubygemsFile = RubygemsFile.create((String)path, null);
        if (rubygemsFile == null) {
            this.log.warn("Skipping non-rubygem file in repository {} {}", (Object)this.getRepository(), (Object)path);
        }
        return rubygemsFile;
    }
}

