/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.repository.migrators.orient.OrientRepositoryMigratorSupport;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.orient.raw.RawContentFacet;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="raw-hosted")
@Priority(value=0x7FFFFFFF)
public class RawHostedRepositoryMigrator
extends OrientRepositoryMigratorSupport {
    @Override
    @Nullable
    protected Asset recordMetadata(StorageTx tx, RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        RawContentFacet rawContentFacet = (RawContentFacet)this.getRepository().facet(RawContentFacet.class);
        String componentName = change.getChange().getComponent().getName();
        String componentGroup = change.getChange().getComponent().getGroup();
        return rawContentFacet.getOrCreateAsset(this.getRepository(), componentName, componentGroup, this.getAssetName(change));
    }

    @Override
    protected void delete(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        RawContentFacet facet = (RawContentFacet)this.getRepository().facet(RawContentFacet.class);
        try {
            this.inStorageTx(() -> {
                facet.delete(this.getItemPath(change));
                return null;
            });
        }
        catch (IOException e) {
            this.log.warn("Exception while processing delete change: {}", (Object)change, (Object)e);
        }
    }

    @Override
    protected void streamContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TempBlob blob = this.getTempBlob(change);){
            if (blob == null) {
                return;
            }
            this.inStorageTx(() -> {
                StorageTx tx = (StorageTx)UnitOfWork.currentTx();
                Bucket bucket = tx.findBucket(this.getRepository());
                Asset asset = tx.findAssetWithProperty("name", (Object)this.getAssetName(change), bucket);
                Preconditions.checkState((asset != null ? 1 : 0) != 0);
                this.applyLastModified(change, asset);
                tx.setBlob(asset, this.getItemPath(change), blob, null, this.getContentType(change), true);
                tx.saveAsset(asset);
                return null;
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void applyLastModified(RepositoryChangelogClient.ChangeEntryXO change, Asset asset) {
        DateTime lastUpdated = this.getLastUpdated(change);
        if (lastUpdated != null) {
            Content.applyToAsset((Asset)asset, (AttributesMap)new AttributesMap((Map)ImmutableMap.of((Object)"last_modified", (Object)lastUpdated)));
        }
    }

    @Override
    public List<HashAlgorithm> getRequiredHashAlgorithms() {
        return Arrays.asList(HashAlgorithm.MD5, HashAlgorithm.SHA1);
    }

    @Override
    protected void hardLinkContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        this.inStorageTx(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Bucket bucket = tx.findBucket(this.getRepository());
            Asset asset = tx.findAssetWithProperty("name", (Object)this.getAssetName(change), bucket);
            Preconditions.checkState((asset != null ? 1 : 0) != 0);
            this.applyLastModified(change, asset);
            tx.setBlob(asset, this.getItemPath(change), this.getStoragePath(change), this.getHashCodes(change), null, this.getContentType(change), this.getSize(change));
            tx.saveAsset(asset);
            return null;
        });
    }

    @Override
    @Nullable
    protected Asset getIngestedContent(StorageTx tx, RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        Bucket bucket = tx.findBucket(this.getRepository());
        return tx.findAssetWithProperty("name", (Object)this.getAssetName(change), bucket);
    }
}

