/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.firewall.orient.OrientFirewallMigrationFacade;
import com.sonatype.nexus.migration.repository.RepositoryMigrator;
import com.sonatype.nexus.migration.repository.migrators.RepositoryMigratorSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.Operation;
import org.sonatype.nexus.transaction.UnitOfWork;

public abstract class OrientRepositoryMigratorSupport
extends RepositoryMigratorSupport
implements RepositoryMigrator {
    private OrientFirewallMigrationFacade firewallMigrationFacade;

    @Inject
    public void setFirewallMigrationFacade(OrientFirewallMigrationFacade firewallMigrationFacade) {
        this.firewallMigrationFacade = (OrientFirewallMigrationFacade)Preconditions.checkNotNull((Object)firewallMigrationFacade);
    }

    @Override
    protected void createOrUpdateFirewall(RepositoryChangelogClient.ChangeEntryXO change) {
        this.firewallMigrationFacade.maybeRecordAssetAttributes(this.getRepository(), change, tx -> {
            try {
                return this.getIngestedContent((StorageTx)tx, change);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @Nullable
    protected abstract Asset recordMetadata(StorageTx var1, RepositoryChangelogClient.ChangeEntryXO var2) throws IOException;

    @Override
    protected void recordMetadata(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        this.inStorageTx(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Asset asset = this.recordMetadata(tx, change);
            if (asset != null) {
                tx.saveAsset(asset);
            }
            return null;
        });
    }

    @Nullable
    protected abstract Asset getIngestedContent(StorageTx var1, RepositoryChangelogClient.ChangeEntryXO var2) throws IOException;

    protected <T> T inStorageTx(Operation<T, IOException> operation) throws IOException {
        return (T)TransactionalStoreBlob.operation.withDb(((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier()).throwing(IOException.class).call(operation);
    }

    @Override
    protected TempBlob getTempBlob(RepositoryChangelogClient.ChangeEntryXO change) {
        return super.getTempBlob(change);
    }

    @Override
    protected TempBlob createTempBlob(InputStream inputStream, Map<String, String> headers, Iterable<HashAlgorithm> hashAlgorithms) {
        return ((StorageFacet)this.getRepository().facet(StorageFacet.class)).createTempBlob(inputStream, hashAlgorithms);
    }
}

