/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators.orient;

import com.sonatype.nexus.migration.assistant.MigrationAssistant;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.repository.IngestMethod;
import com.sonatype.nexus.migration.repository.migrators.orient.OrientNugetHostedRepositoryMigrator;
import com.sonatype.nexus.migration.repository.migrators.orient.ProxyMetadataHelper;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageTx;

@Named(value="nuget-proxy")
public class OrientNugetProxyRepositoryMigrator
extends OrientNugetHostedRepositoryMigrator {
    private final RepositoryManager repositoryManager;

    @Inject
    public OrientNugetProxyRepositoryMigrator(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    @Override
    public void init(MigrationAssistant assistant, Repository repository, IngestMethod ingestMethod) {
        try {
            Configuration configuration = repository.getConfiguration().copy();
            configuration.attributes("nugetProxy").set("nugetVersion", (Object)"V2");
            this.repositoryManager.update(configuration);
            super.init(assistant, repository, ingestMethod);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Asset getOrCreateAsset(StorageTx tx, NugetPackageCoords coords, RepositoryChangelogClient.ChangeEntryXO change) {
        Asset asset = super.getOrCreateAsset(tx, coords, change);
        ProxyMetadataHelper.updateProxyMetadata(change, asset);
        return asset;
    }
}

