/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators.orient;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.repository.migrators.orient.OrientRepositoryMigratorSupport;
import com.sonatype.nexus.repository.npm.orient.NpmFacet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.AssetManager;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentMaintenance;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="npm")
public class NpmRepositoryMigrator
extends OrientRepositoryMigratorSupport {
    private static final String GENERATED_ON_REQUEST = "generated-on-request";
    private static final String METADATA_DIST = "dist";
    private static final String METADATA_NAME = "name";
    private static final String METADATA_VERSIONS = "versions";
    private static final String METADATA_TARBALL = "tarball";
    private static final String NPM = "npm";
    private static final String PACKAGE_ROOT = "PACKAGE_ROOT";
    private static final String TARBALL = "TARBALL";
    private static final String TIME = "time";
    private static final ObjectMapper mapper = new ObjectMapper();
    private final AssetManager assetManager;

    static {
        mapper.disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET});
    }

    @Inject
    public NpmRepositoryMigrator(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Override
    @Nullable
    protected Asset recordMetadata(StorageTx tx, RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        tx.saveAsset(this.getOrCreatePackageRootAsset(tx, change));
        return this.getOrCreatePackageAsset(tx, change);
    }

    private Asset getOrCreatePackageAsset(StorageTx tx, RepositoryChangelogClient.ChangeEntryXO change) {
        String assetName = this.getAssetName(change);
        String componentName = change.getChange().getComponent().getName();
        String componentVersion = change.getChange().getComponent().getVersion();
        String componentGroup = change.getChange().getComponent().getGroup();
        Bucket bucket = tx.findBucket(this.getRepository());
        Component component = this.findComponent(tx, change);
        if (component == null) {
            component = ((Component)tx.createComponent(bucket, this.getRepository().getFormat()).name(componentName)).group(componentGroup).version(componentVersion);
        }
        tx.saveComponent(component);
        Asset asset = tx.findAssetWithProperty(METADATA_NAME, (Object)assetName, component);
        if (asset == null) {
            asset = (Asset)tx.createAsset(bucket, component).name(assetName);
        }
        asset.formatAttributes().set("asset_kind", (Object)TARBALL);
        this.assetManager.maybeUpdateLastDownloaded(asset);
        return asset;
    }

    private Asset getOrCreatePackageRootAsset(StorageTx tx, RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        String packageName = NpmRepositoryMigrator.getPackageName(change);
        Bucket bucket = tx.findBucket(this.getRepository());
        Format format = this.getRepository().getFormat();
        Asset asset = tx.findAssetWithProperty(METADATA_NAME, (Object)packageName, bucket);
        if (asset == null) {
            asset = (Asset)tx.createAsset(bucket, format).name(packageName);
            asset.formatAttributes().set("asset_kind", (Object)PACKAGE_ROOT);
        }
        this.assetManager.maybeUpdateLastDownloaded(asset);
        NestedAttributesMap packageRoot = change.getChange().getAsset().attributes().child(NPM);
        NpmRepositoryMigrator.rewriteGeneratedOnRequestTarballUrls(packageRoot);
        byte[] packageRootBytes = NpmRepositoryMigrator.bytes(packageRoot);
        tx.setBlob(asset, packageName, () -> new ByteArrayInputStream(packageRootBytes), Collections.singletonList(HashAlgorithm.SHA1), null, "application/json", true);
        return asset;
    }

    @Override
    protected void delete(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        if (this.isTarball(change)) {
            this.deleteTarball(change);
        } else {
            this.deletePackage(change);
        }
    }

    private boolean isTarball(RepositoryChangelogClient.ChangeEntryXO change) {
        return this.getItemPath(change).endsWith(".tgz");
    }

    private void deleteTarball(RepositoryChangelogClient.ChangeEntryXO change) {
        EntityId assetId = this.findTarballEntityId(this.getItemPath(change));
        if (assetId != null) {
            ((ComponentMaintenance)this.getRepository().facet(ComponentMaintenance.class)).deleteAsset(assetId);
        }
    }

    private EntityId findTarballEntityId(String tarballPath) {
        return (EntityId)Transactional.operation.withDb(((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier()).call(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Asset asset = tx.findAssetWithProperty(METADATA_NAME, (Object)tarballPath, tx.findBucket(this.getRepository()));
            if (asset != null && asset.getEntityMetadata() != null) {
                return asset.getEntityMetadata().getId();
            }
            return null;
        });
    }

    private void deletePackage(RepositoryChangelogClient.ChangeEntryXO change) {
        String itemPath = this.getItemPath(change);
        if (!Strings2.isBlank((String)itemPath)) {
            ComponentMaintenance maintainer = (ComponentMaintenance)this.getRepository().facet(ComponentMaintenance.class);
            this.findPackageEntityIds(itemPath).forEach(arg_0 -> ((ComponentMaintenance)maintainer).deleteComponent(arg_0));
        }
    }

    private Collection<EntityId> findPackageEntityIds(String packageName) {
        return (Collection)Transactional.operation.withDb(((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier()).call(() -> StreamSupport.stream(this.findComponents((StorageTx)UnitOfWork.currentTx(), packageName).spliterator(), false).map(Entity::getEntityMetadata).filter(m -> m != null).map(EntityMetadata::getId).collect(Collectors.toList()));
    }

    @Override
    protected void streamContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TempBlob blob = this.getTempBlob(change);){
            if (blob == null) {
                return;
            }
            this.attachContent(change, tx -> tx.createBlob(this.getAssetName(change), blob, null, this.getContentType(change), true));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public List<HashAlgorithm> getRequiredHashAlgorithms() {
        return Collections.singletonList(HashAlgorithm.SHA1);
    }

    @Override
    protected void hardLinkContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        this.attachContent(change, tx -> tx.createBlob(this.getAssetName(change), this.getStoragePath(change), this.getHashCodes(change), null, this.getContentType(change), this.getSize(change)));
    }

    @Override
    @Nullable
    protected Asset getIngestedContent(StorageTx tx, RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        String assetName = this.getAssetName(change);
        Component component = this.findComponent(tx, change);
        if (component == null) {
            return null;
        }
        return tx.findAssetWithProperty(METADATA_NAME, (Object)assetName, component);
    }

    @Override
    public String calculatePath(RepositoryChangelogClient.ChangeEntryXO change) {
        if (change.getChange().getComponent() == null) {
            return change.getChange().getPath();
        }
        return NpmRepositoryMigrator.getPackageName(change);
    }

    private void attachContent(RepositoryChangelogClient.ChangeEntryXO change, BlobGetter blobGetter) throws IOException {
        String tarballName = this.getAssetName(change);
        String packageName = NpmRepositoryMigrator.getPackageName(change);
        Repository repository = this.getRepository();
        NpmFacet npmFacet = (NpmFacet)repository.facet(NpmFacet.class);
        this.inStorageTx(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            AssetBlob assetBlob = blobGetter.getBlob(tx);
            AttributesMap contentAttributes = new AttributesMap();
            contentAttributes.set("last_modified", (Object)this.getTarballLastModified(change));
            npmFacet.putTarball(packageName, tarballName, assetBlob, contentAttributes);
            return null;
        });
    }

    private DateTime getTarballLastModified(RepositoryChangelogClient.ChangeEntryXO change) {
        String version = (String)Preconditions.checkNotNull((Object)change.getChange().getComponent().getVersion());
        String versionTime = (String)change.getChange().getAsset().attributes().child(NPM).child(TIME).get(version, String.class);
        return Strings2.isBlank((String)versionTime) ? this.getLastUpdated(change) : DateTime.parse((String)versionTime);
    }

    @Nullable
    private Component findComponent(StorageTx tx, RepositoryChangelogClient.ChangeEntryXO change) {
        String name = change.getChange().getComponent().getName();
        String version = change.getChange().getComponent().getVersion();
        String group = change.getChange().getComponent().getGroup();
        return this.findComponent(tx, group, name, version);
    }

    @Nullable
    private Component findComponent(StorageTx tx, String group, String name, String version) {
        if (name != null && version != null) {
            Query.Builder builder = Query.builder().where(METADATA_NAME).eq((Object)name).and("version").eq((Object)version);
            if (group != null) {
                builder.and("group").eq((Object)group);
            } else {
                builder.and("group").isNull();
            }
            Iterable components = tx.findComponents(builder.build(), Collections.singletonList(this.getRepository()));
            return (Component)Iterables.getFirst((Iterable)components, null);
        }
        return null;
    }

    private Iterable<Component> findComponents(StorageTx tx, String name) {
        Preconditions.checkNotNull((Object)name);
        return tx.findComponents(Query.builder().where(METADATA_NAME).eq((Object)name).build(), Collections.singletonList(this.getRepository()));
    }

    /*
     * Loose catch block
     */
    private static byte[] bytes(NestedAttributesMap packageRoot) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            byte[] byArray;
            OutputStreamWriter writer;
            ByteArrayOutputStream byteArrayOutputStream;
            block16: {
                block15: {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8);
                    mapper.writeValue((Writer)writer, (Object)packageRoot.backing());
                    byArray = byteArrayOutputStream.toByteArray();
                    if (writer == null) break block15;
                    writer.close();
                }
                if (byteArrayOutputStream == null) break block16;
                byteArrayOutputStream.close();
            }
            return byArray;
            {
                catch (Throwable throwable2) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (byteArrayOutputStream != null) {
                            byteArrayOutputStream.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static String getPackageName(RepositoryChangelogClient.ChangeEntryXO change) {
        String name = (String)Preconditions.checkNotNull((Object)change.getChange().getComponent().getName());
        String group = change.getChange().getComponent().getGroup();
        String packageName = group != null ? "@" + group + "/" + name : name;
        return packageName;
    }

    private static void rewriteGeneratedOnRequestTarballUrls(NestedAttributesMap packageRoot) {
        NestedAttributesMap versions = packageRoot.child(METADATA_VERSIONS);
        for (String version : versions.keys()) {
            if (!(versions.get(version) instanceof Map)) continue;
            NestedAttributesMap versionMetadata = versions.child(version);
            String name = (String)versionMetadata.get(METADATA_NAME, String.class);
            NestedAttributesMap distMetadata = versionMetadata.child(METADATA_DIST);
            if (!GENERATED_ON_REQUEST.equals(distMetadata.get(METADATA_TARBALL, String.class))) continue;
            distMetadata.set(METADATA_TARBALL, (Object)String.format("%s-%s.tgz", name, version));
        }
    }

    private static interface BlobGetter {
        public AssetBlob getBlob(StorageTx var1) throws IOException;
    }
}

