/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators.orient;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.repository.IngestMethod;
import com.sonatype.nexus.migration.repository.migrators.orient.Maven2RepositoryMigratorSupport;
import com.sonatype.nexus.migration.repository.migrators.orient.ProxyMetadataHelper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.orient.maven.OrientMavenFacet;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetManager;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="maven2-proxy")
public class Maven2ProxyRepositoryMigrator
extends Maven2RepositoryMigratorSupport {
    private static final String REPOSITORY_METADATA = "REPOSITORY_METADATA";
    private static final String ARTIFACT_SUBORDINATE = "ARTIFACT_SUBORDINATE";
    private static final String OTHER = "OTHER";

    @Inject
    public Maven2ProxyRepositoryMigrator(AssetManager assetManager) {
        super(assetManager);
    }

    @Override
    protected void ingestContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        MavenFacet mavenFacet = (MavenFacet)this.getRepository().facet(MavenFacet.class);
        MavenPath mavenPath = mavenFacet.getMavenPathParser().parsePath(this.getAssetName(change));
        super.ingestContent(change);
        if (IngestMethod.DOWNLOAD != this.getIngestMethod()) {
            this.inStorageTx(() -> {
                this.maybeCreateHashAssets(mavenPath, change);
                return null;
            });
        }
    }

    private void maybeCreateHashAssets(MavenPath mavenPath, RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        if (mavenPath.isSignature() || mavenPath.getPath().endsWith(".asc")) {
            this.log.trace("maybeCreateHashAssets - skipping signature: {}", (Object)mavenPath);
            return;
        }
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAssetWithProperty("name", (Object)mavenPath.getPath(), tx.findBucket(this.getRepository()));
        if (asset != null) {
            OrientMavenFacet mavenFacet = (OrientMavenFacet)this.getRepository().facet(OrientMavenFacet.class);
            MavenPathParser mavenPathParser = mavenFacet.getMavenPathParser();
            for (Map.Entry checksum : asset.getChecksums((Iterable)MavenPath.HashType.ALGORITHMS).entrySet()) {
                MavenPath hashPath = mavenPathParser.parsePath(String.valueOf(mavenPath.getPath()) + "." + ((HashAlgorithm)checksum.getKey()).name());
                Asset hashAsset = this.getOrCreateAsset(tx, hashPath, change, this.getHashAssetKind(hashPath));
                this.log.trace("maybeCreateHashAssets - creating hash: {}", (Object)hashPath);
                tx.saveAsset(hashAsset);
                mavenFacet.put(hashPath, (Payload)new BytesPayload(((HashCode)checksum.getValue()).toString().getBytes(StandardCharsets.UTF_8), "text/plain"));
            }
        }
    }

    private String getHashAssetKind(MavenPath mavenPath) {
        Preconditions.checkState((boolean)mavenPath.isHash(), (String)"expected a maven path to a hash file: %s", (Object)mavenPath);
        MavenPathParser mavenPathParser = ((MavenFacet)this.getRepository().facet(MavenFacet.class)).getMavenPathParser();
        if (mavenPathParser.isRepositoryMetadata(mavenPath)) {
            return REPOSITORY_METADATA;
        }
        if (mavenPath.isSubordinate()) {
            return ARTIFACT_SUBORDINATE;
        }
        return OTHER;
    }

    @Override
    public void processChange(RepositoryChangelogClient.ChangeEntryXO change) throws Exception {
        String itemPath = this.getItemPath(change);
        if (IngestMethod.DOWNLOAD != this.getIngestMethod() && (itemPath.endsWith(".md5") || itemPath.endsWith(".sha1"))) {
            this.log.trace("processChange - skipping: {}", (Object)change);
        } else {
            super.processChange(change);
        }
    }

    @Override
    protected Asset getOrCreateAsset(StorageTx tx, MavenPath mavenPath, RepositoryChangelogClient.ChangeEntryXO change) {
        Asset asset = super.getOrCreateAsset(tx, mavenPath, change);
        ProxyMetadataHelper.updateProxyMetadata(change, asset);
        return asset;
    }
}

