/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators.datastore;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.repository.migrators.datastore.DatastoreRepositoryMigratorSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.rubygems.datastore.RubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.marshal.GemSpecification;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.reader.UnicodeReader;

@Named(value="rubygems")
public class RubygemsRepositoryMigrator
extends DatastoreRepositoryMigratorSupport {
    private static final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    @Override
    public List<HashAlgorithm> getRequiredHashAlgorithms() {
        return Arrays.asList(HashAlgorithm.MD5, HashAlgorithm.SHA1);
    }

    @Override
    protected void delete(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        String path = this.nx2PathToNx3(change);
        RubygemsContentFacet facet = (RubygemsContentFacet)this.getRepository().facet(RubygemsContentFacet.class);
        facet.deleteGem(path);
    }

    @Override
    protected void recordMetadata(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        String path = this.getAssetName(change);
        if (path.endsWith(".gem")) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (TempBlob tempBlob = this.getTempBlob(change);){
                if (tempBlob == null) {
                    return;
                }
                RubygemsContentFacet rubygemsContentFacet = (RubygemsContentFacet)this.getRepository().facet(RubygemsContentFacet.class);
                GemSpecification gemSpecification = this.retrieveGemSpecification((InputStreamSupplier)tempBlob);
                rubygemsContentFacet.putGem(gemSpecification, tempBlob);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    @Override
    @Nullable
    protected Asset getIngestedContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        String path = this.getAssetName(change);
        return this.assets().path(path).find().orElse(null);
    }

    private String nx2PathToNx3(RepositoryChangelogClient.ChangeEntryXO change) {
        String path = (String)Preconditions.checkNotNull((Object)change.getChange().getPath());
        if (path.endsWith(".gem")) {
            return "gems" + path.substring(path.lastIndexOf(47));
        }
        return path;
    }

    private GemSpecification retrieveGemSpecification(InputStreamSupplier streamOfGem) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TarArchiveInputStream tar = new TarArchiveInputStream(streamOfGem.get());){
            TarArchiveEntry entry = tar.getNextTarEntry();
            while (entry != null && !"metadata.gz".equals(entry.getName())) {
                entry = tar.getNextTarEntry();
            }
            if (entry == null || !"metadata.gz".equals(entry.getName())) {
                throw new IOException("not found in tar-archive: metadata.gz");
            }
            GZIPInputStream gis = new GZIPInputStream((InputStream)tar);
            Map<String, Object> yamlGemspec = this.load(gis);
            return new GemSpecification(yamlGemspec);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Map<String, Object> load(InputStream is) throws IOException {
        Map map;
        Preconditions.checkNotNull((Object)is);
        String data = IOUtils.toString((Reader)new UnicodeReader(is));
        try {
            LoadSettings settings = LoadSettings.builder().setAllowDuplicateKeys(true).setMaxAliasesForCollections(40).build();
            Load loader = new Load(settings);
            String cleanedData = data.replaceAll("!ruby/object.*", "").replaceAll("!binary.*", "");
            map = (Map)loader.loadFromString(cleanedData);
        }
        catch (YAMLException yAMLException) {
            map = (Map)mapper.readValue(data, Map.class);
        }
        return map;
    }
}

