/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators.datastore;

import com.google.common.base.Joiner;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.repository.migrators.NugetMigratorHelper;
import com.sonatype.nexus.migration.repository.migrators.datastore.DatastoreRepositoryMigratorSupport;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.datastore.NugetContentFacet;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import com.sonatype.nexus.repository.nuget.odata.ODataFeedUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

public class NugetRepositoryMigratorSupport
extends DatastoreRepositoryMigratorSupport {
    static final String NUGET = "nuget";

    @Override
    @Nullable
    protected Asset getIngestedContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        return this.assets().path(this.getAssetName(change)).find().orElse(null);
    }

    @Override
    public List<HashAlgorithm> getRequiredHashAlgorithms() {
        return NugetPackageUtils.HASH_ALGORITHMS;
    }

    @Override
    protected void delete(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        NugetContentFacet contentFacet = (NugetContentFacet)this.getRepository().facet(NugetContentFacet.class);
        if (change.getChange() != null) {
            String path = change.getChange().getPath();
            String[] splitPath = this.removeStartSlash(path).split("/");
            String packageId = splitPath[0];
            String version = splitPath[1];
            contentFacet.delete(packageId, version);
            this.log.debug("Deleting package while migration: {}", (Object)path);
        }
    }

    @Override
    protected void recordMetadata(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        NugetPackageCoords coords = this.nugetCoords(change);
        ContentFacet contentFacet = (ContentFacet)this.getRepository().facet(ContentFacet.class);
        NestedAttributesMap data = change.getChange().getAsset().attributes().child(NUGET);
        FluentComponent component = contentFacet.components().name(coords.getId()).version(coords.getVersion()).getOrCreate();
        FluentAsset asset = component.asset(this.getAssetName(change)).save();
        Map<String, Object> assetAttributes = this.extractFormatAttributes(data);
        TempBlob tempBlob = this.getTempBlob(change);
        if (tempBlob != null) {
            Map<String, String> metadata = NugetMigratorHelper.getMetadata(tempBlob, change);
            String dependencies = metadata.get("DEPENDENCIES");
            assetAttributes.put("dependencies", dependencies);
        }
        asset.attributes(AttributeOperation.OVERLAY, NUGET, assetAttributes);
    }

    private Map<String, Object> extractFormatAttributes(NestedAttributesMap data) {
        HashMap<String, Object> nugetAttributes = new HashMap<String, Object>();
        nugetAttributes.put("authors", data.get("AUTHORS"));
        nugetAttributes.put("copyright", data.get("COPYRIGHT"));
        nugetAttributes.put("dependencies", data.get("DEPENDENCIES"));
        nugetAttributes.put("description", data.get("DESCRIPTION"));
        nugetAttributes.put("gallery_details_url", data.get("GALLERYDETAILSURL"));
        nugetAttributes.put("icon_url", data.get("ICONURL"));
        nugetAttributes.put("id", data.get("ID"));
        nugetAttributes.put("is_prerelease", data.get("ISPRERELEASE"));
        nugetAttributes.put("language", data.get("LANGUAGE"));
        nugetAttributes.put("license", data.get("LICENSE"));
        nugetAttributes.put("license_type", data.get("LICENSETYPE"));
        nugetAttributes.put("license_url", data.get("LICENSEURL"));
        nugetAttributes.put("location", data.get("LOCATION"));
        nugetAttributes.put("package_hash", data.get("PACKAGEHASH"));
        nugetAttributes.put("package_hash_algorithm", data.get("PACKAGEHASHALGORITHM"));
        Number pkgSizeNum = (Number)data.get("PACKAGESIZE", Number.class);
        nugetAttributes.put("package_size", pkgSizeNum == null ? null : Long.valueOf(pkgSizeNum.longValue()));
        nugetAttributes.put("project_url", data.get("PROJECTURL"));
        nugetAttributes.put("release_notes", data.get("RELEASENOTES"));
        nugetAttributes.put("report_abuse_url", data.get("REPORTABUSEURL"));
        nugetAttributes.put("require_license_acceptance", data.get("REQUIRELICENSEACCEPTANCE", Boolean.class));
        nugetAttributes.put("summary", data.get("SUMMARY"));
        nugetAttributes.put("tags", data.get("TAGS"));
        nugetAttributes.put("title", data.get("TITLE"));
        nugetAttributes.put("version", data.get("VERSION"));
        nugetAttributes.put("min_client_version", data.get("MINCLIENTVERSION"));
        nugetAttributes.put("download_count", data.get("DOWNLOADCOUNT"));
        nugetAttributes.put("version_download_count", data.get("VERSIONDOWNLOADCOUNT"));
        nugetAttributes.put("created", this.getDatetime(data, "CREATED"));
        nugetAttributes.put("published", this.getDatetime(data, "PUBLISHED"));
        nugetAttributes.put("last_updated", this.getDatetime(data, "LASTUPDATED"));
        this.updateDerivedFields(data, nugetAttributes);
        return nugetAttributes;
    }

    private void updateDerivedFields(NestedAttributesMap data, Map<String, Object> nugetAttributes) {
        Joiner joiner = Joiner.on((String)" ").skipNulls();
        String keywords = joiner.join(data.get("ID"), data.get("TITLE"), new Object[]{data.get("DESCRIPTION"), data.get("TAGS"), data.get("AUTHORS")});
        nugetAttributes.put("keywords", keywords.toLowerCase());
        String title = (String)data.get("TITLE", String.class, (Object)"");
        String id = (String)data.get("ID", String.class, (Object)"");
        String value = String.valueOf(title) + id;
        nugetAttributes.put("name_order", value.toLowerCase(Locale.ENGLISH));
    }

    private NugetPackageCoords nugetCoords(RepositoryChangelogClient.ChangeEntryXO change) {
        String packageId = change.getChange().getComponent().getName();
        String version = change.getChange().getComponent().getVersion();
        return new NugetPackageCoords(packageId, version);
    }

    @Override
    protected String getAssetName(RepositoryChangelogClient.ChangeEntryXO change) {
        NugetPackageCoords coords = this.nugetCoords(change);
        return String.format("/%s/%s", coords.getId(), coords.getVersion());
    }

    private String removeStartSlash(String path) {
        String pathWithoutLeadingSlash = path;
        if (path.startsWith("/")) {
            pathWithoutLeadingSlash = path.substring(1);
        }
        return pathWithoutLeadingSlash;
    }

    private String getDatetime(NestedAttributesMap attributes, String key) {
        Long now = DateTime.now().getMillis();
        return ODataFeedUtils.datetime((long)((Long)attributes.get(key, Long.class, (Object)now)));
    }
}

