/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators.datastore;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.repository.migrators.datastore.DatastoreRepositoryMigratorSupport;
import com.sonatype.nexus.repository.content.npm.NpmContentFacet;
import com.sonatype.nexus.repository.npm.NpmAttributeUtil;
import com.sonatype.nexus.repository.npm.NpmCoordinateUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="npm")
public class NpmRepositoryMigrator
extends DatastoreRepositoryMigratorSupport {
    private static final String GENERATED_ON_REQUEST = "generated-on-request";
    private static final String TARBALL = "TARBALL";
    private static final String PACKAGE_ROOT = "PACKAGE_ROOT";
    private static final String NPM_FORMAT = "npm";
    private static final ObjectMapper mapper = new ObjectMapper();
    private final NpmAttributeUtil npmAttributeUtil;

    static {
        mapper.disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET});
    }

    @Inject
    public NpmRepositoryMigrator(NpmAttributeUtil npmAttributeUtil) {
        this.npmAttributeUtil = (NpmAttributeUtil)Preconditions.checkNotNull((Object)npmAttributeUtil);
    }

    @Override
    public List<HashAlgorithm> getRequiredHashAlgorithms() {
        return Collections.singletonList(HashAlgorithm.SHA1);
    }

    @Override
    protected void delete(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        if (change.getChange() != null) {
            String path = change.getChange().getPath();
            if (path.endsWith(".tgz")) {
                this.deleteTarball(change);
            } else {
                this.deleteComponent(change);
            }
            this.log.debug("Deleting package while migration: {}", (Object)path);
        }
    }

    private boolean deleteTarball(RepositoryChangelogClient.ChangeEntryXO change) {
        NpmContentFacet facet = (NpmContentFacet)this.getRepository().facet(NpmContentFacet.class);
        String path = change.getChange().getPath();
        return facet.assets().path(path).find().map(FluentAsset::delete).orElse(false);
    }

    private void deleteComponent(RepositoryChangelogClient.ChangeEntryXO change) {
        boolean assetDeleted = this.deleteTarball(change);
        if (assetDeleted) {
            NpmContentFacet facet = (NpmContentFacet)this.getRepository().facet(NpmContentFacet.class);
            String path = this.getAssetName(change);
            String version = NpmCoordinateUtil.extractVersion((String)path);
            String[] splitPath = path.split("/");
            String name = splitPath[0];
            String scope = null;
            int slashIndex = path.indexOf(47);
            if (name.startsWith("@") && slashIndex > -1) {
                scope = name.substring(1, slashIndex);
                name = splitPath[1].substring(slashIndex + 1, name.length());
            }
            facet.components().name(name).namespace(Strings.nullToEmpty(scope)).version(version).find().ifPresent(this::deleteIfNoAssetsLeft);
        }
    }

    private void deleteIfNoAssetsLeft(FluentComponent component) {
        if (component.assets().isEmpty()) {
            component.delete();
        }
    }

    @Override
    protected void recordMetadata(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        NpmContentFacet contentFacet = (NpmContentFacet)this.getRepository().facet(NpmContentFacet.class);
        String name = change.getChange().getComponent().getName();
        String version = change.getChange().getComponent().getVersion();
        String namespace = change.getChange().getComponent().getGroup();
        NestedAttributesMap attributesMap = change.getChange().getAsset().attributes().child(NPM_FORMAT);
        this.savePackageRoot(change, contentFacet);
        FluentComponent component = contentFacet.components().name(name).namespace(Strings.nullToEmpty((String)namespace)).version(version).getOrCreate();
        Map assetAttributes = this.npmAttributeUtil.extractFormatAttributes(attributesMap, version);
        component.asset(this.getAssetName(change)).kind(TARBALL).attributes(NPM_FORMAT, (Object)assetAttributes).save();
    }

    @Override
    @Nullable
    protected Asset getIngestedContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        String path = change.getChange().getPath();
        return this.assets().path(path).find().orElse(null);
    }

    private void savePackageRoot(RepositoryChangelogClient.ChangeEntryXO change, NpmContentFacet contentFacet) throws IOException {
        String packageName = NpmRepositoryMigrator.getPackageName(change);
        NestedAttributesMap packageRoot = change.getChange().getAsset().attributes().child(NPM_FORMAT);
        NpmRepositoryMigrator.rewriteGeneratedOnRequestTarballUrls(packageRoot);
        byte[] bytes = NpmRepositoryMigrator.bytes(packageRoot);
        TempBlob tempBlob = contentFacet.blobs().ingest((InputStream)new ByteArrayInputStream(bytes), "application/json", Collections.singletonList(HashAlgorithm.SHA1));
        this.assets().path(packageName).kind(PACKAGE_ROOT).blob(tempBlob).save();
    }

    private static void rewriteGeneratedOnRequestTarballUrls(NestedAttributesMap packageRoot) {
        NestedAttributesMap versions = packageRoot.child("versions");
        for (String version : versions.keys()) {
            if (!(versions.get(version) instanceof Map)) continue;
            NestedAttributesMap versionMetadata = versions.child(version);
            String name = (String)versionMetadata.get("name", String.class);
            NestedAttributesMap distMetadata = versionMetadata.child("dist");
            if (!GENERATED_ON_REQUEST.equals(distMetadata.get("tarball", String.class))) continue;
            distMetadata.set("tarball", (Object)String.format("%s-%s.tgz", name, version));
        }
    }

    /*
     * Loose catch block
     */
    private static byte[] bytes(NestedAttributesMap packageRoot) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            byte[] byArray;
            OutputStreamWriter writer;
            ByteArrayOutputStream byteArrayOutputStream;
            block16: {
                block15: {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8);
                    mapper.writeValue((Writer)writer, (Object)packageRoot.backing());
                    byArray = byteArrayOutputStream.toByteArray();
                    if (writer == null) break block15;
                    writer.close();
                }
                if (byteArrayOutputStream == null) break block16;
                byteArrayOutputStream.close();
            }
            return byArray;
            {
                catch (Throwable throwable2) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (byteArrayOutputStream != null) {
                            byteArrayOutputStream.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static String getPackageName(RepositoryChangelogClient.ChangeEntryXO change) {
        String name = (String)Preconditions.checkNotNull((Object)change.getChange().getComponent().getName());
        String group = change.getChange().getComponent().getGroup();
        String packageName = group != null ? "/@" + group + "/" + name : "/" + name;
        return packageName;
    }
}

