/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators;

import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.migration.repository.RepositoryConfigurationFactory;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.maven.VersionPolicy;

public abstract class RepositoryConfigurationFactorySupport
implements RepositoryConfigurationFactory {
    protected static final String AUTO_BLOCK = "autoBlock";
    protected static final String BROWSEABLE = "browseable";
    protected static final String CONTENT_MAX_AGE = "contentMaxAge";
    protected static final String EXPOSED = "exposed";
    protected static final String INDEXABLE = "indexable";
    protected static final String MEMBER_NAMES = "memberNames";
    protected static final String METADATA_MAX_AGE = "metadataMaxAge";
    protected static final String NFC_ACTIVE = "notFoundCacheActive";
    protected static final String NFC_TIME_TO_LIVE = "notFoundCacheTimeToLive";
    protected static final String PATH_PREFIX = "pathPrefix";
    protected static final String REMOTE_URL = "remoteUrl";
    protected static final String SEARCHABLE = "searchable";
    protected static final String FILE_TYPE_VALIDATION = "fileTypeValidation";
    protected static final String VERSION_POLICY = "versionPolicy";
    protected static final Map<String, WritePolicy> WRITE_POLICY_MAP = ImmutableMap.of((Object)"allow-write", (Object)WritePolicy.ALLOW, (Object)"allow-write-once", (Object)WritePolicy.ALLOW_ONCE, (Object)"read-only", (Object)WritePolicy.DENY);
    protected static final Map<String, VersionPolicy> VERSION_POLICY_MAP = ImmutableMap.of((Object)"release", (Object)VersionPolicy.RELEASE, (Object)"snapshot", (Object)VersionPolicy.SNAPSHOT, (Object)"mixed", (Object)VersionPolicy.MIXED);
    protected RepositoryManager repositoryManager;

    @Inject
    public void setRepositoryManager(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    protected String getRecipeName() {
        Named named = this.getClass().getAnnotation(Named.class);
        if (named == null) {
            throw new UnsupportedOperationException();
        }
        return named.value();
    }

    protected void migrateContentTypeValidationConfiguration(Configuration config, Map<String, Object> input) {
        NestedAttributesMap attributes = config.attributes("storage");
        attributes.set("strictContentTypeValidation", (Object)Boolean.FALSE);
    }
}

