/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.plan.StepContext;
import com.sonatype.nexus.migration.repository.migrators.RepositoryConfigurationFactorySupport;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.security.PasswordHelper;

public abstract class ProxyRepositoryConfigurationFactorySupport
extends RepositoryConfigurationFactorySupport {
    @VisibleForTesting
    static final String REMOTE_AUTH_TYPE = "remoteAuth.type";
    @VisibleForTesting
    static final String REMOTE_AUTH_USERNAME = "remoteAuth.username";
    @VisibleForTesting
    static final String REMOTE_AUTH_PASSWORD = "remoteAuth.password";
    @VisibleForTesting
    static final String REMOTE_AUTH_NTLM_HOST = "remoteAuth.ntlmHost";
    @VisibleForTesting
    static final String REMOTE_AUTH_NTLM_DOMAIN = "remoteAuth.ntlmDomain";
    @VisibleForTesting
    static final String REMOTE_CONNECTION_TIMEOUT = "remoteConn.timeout";
    @VisibleForTesting
    static final String REMOTE_CONNECTION_RETRY_COUNT = "remoteConn.retryCount";
    private static final String REMOTE_CONNECTION_QUERY = "remoteConn.query";
    @VisibleForTesting
    static final String REMOTE_CONNECTION_USER_AGENT = "remoteConn.userAgent";
    @VisibleForTesting
    static final String REMOTE_CONNECTION_ENABLE_CIRCULAR_REDIRECTS = "remoteConn.enableCircularRedirects";
    @VisibleForTesting
    static final String REMOTE_CONNECTION_ENABLE_COOKIES = "remoteConn.enableCookies";
    private static final String USE_TRUSTSTORE = "useTrustStore";
    private static final String AUDIT_ENABLED_KEY = "auditEnabled";
    private static final String AUDIT_TIMESTAMP_KEY = "auditTimestamp";
    private static final String QUARANTINE_ENABLED_TIMESTAMP_KEY = "quarantineEnabledTimestamp";
    private static final String QUARANTINE_LAST_UPDATED_TIMESTAMP_KEY = "quarantineLastUpdatedTimestamp";
    private static final int MAX_CONNECTION_TIMEOUT = 3600;
    private static final Logger log = LoggerFactory.getLogger(ProxyRepositoryConfigurationFactorySupport.class);
    private PasswordHelper passwordHelper;

    @Override
    public Configuration create(Map<String, Object> input) {
        Configuration config = this.repositoryManager.newConfiguration();
        config.setRecipeName(this.getRecipeName());
        this.migrateContentTypeValidationConfiguration(config, input);
        this.migrateProxyConfiguration(config, input);
        this.migrateNegativeCacheConfiguration(config, input);
        this.migrateHttpClientConfiguration(config, input);
        this.migrateFirewallConfiguration(config, input);
        return config;
    }

    private void migrateProxyConfiguration(Configuration config, Map<String, Object> input) {
        NestedAttributesMap attributes = config.attributes("proxy");
        attributes.set("remoteUrl", input.get("remoteUrl"));
        attributes.set("contentMaxAge", input.get("contentMaxAge"));
        attributes.set("metadataMaxAge", input.get("metadataMaxAge"));
    }

    private void migrateNegativeCacheConfiguration(Configuration config, Map<String, Object> input) {
        NestedAttributesMap attributes = config.attributes("negativeCache");
        attributes.set("enabled", input.get("notFoundCacheActive"));
        attributes.set("timeToLive", input.get("notFoundCacheTimeToLive"));
    }

    private void migrateHttpClientConfiguration(Configuration config, Map<String, Object> input) {
        NestedAttributesMap attributes = config.attributes("httpclient");
        this.migrateHttpClientAuthenticationConfiguration(attributes, input);
        this.migrateHttpClientConnectionConfiguration(attributes, input);
        attributes.set("autoBlock", input.get("autoBlock"));
    }

    private void migrateHttpClientConnectionConfiguration(NestedAttributesMap httpClientConfig, Map<String, Object> input) {
        NestedAttributesMap connConfig = httpClientConfig.child("connection");
        if (input.get(REMOTE_CONNECTION_TIMEOUT) != null) {
            long connectionTimeout = TimeUnit.MILLISECONDS.toSeconds(((Integer)input.get(REMOTE_CONNECTION_TIMEOUT)).intValue());
            if (connectionTimeout > 3600L) {
                log.warn("Limiting HTTP connection timeout from {} to {}", (Object)connectionTimeout, (Object)3600);
                StepContext.getCurrent().log("Limiting HTTP connection timeout from %d to %d", connectionTimeout, 3600);
                connectionTimeout = 3600L;
            }
            connConfig.set("timeout", (Object)((int)connectionTimeout));
        }
        connConfig.set("retries", input.get(REMOTE_CONNECTION_RETRY_COUNT));
        connConfig.set("userAgentSuffix", input.get(REMOTE_CONNECTION_USER_AGENT));
        String query = (String)input.get(REMOTE_CONNECTION_QUERY);
        if (StringUtils.isNotBlank((String)query)) {
            log.warn("Additional URL parameters are no longer supported, ignoring: {}", (Object)query);
            StepContext.getCurrent().log("Additional URL parameters are no longer supported, ignoring: %s", query);
        }
        connConfig.set(USE_TRUSTSTORE, input.get(USE_TRUSTSTORE));
        connConfig.set("enableCircularRedirects", input.get(REMOTE_CONNECTION_ENABLE_CIRCULAR_REDIRECTS));
        connConfig.set("enableCookies", input.get(REMOTE_CONNECTION_ENABLE_COOKIES));
    }

    private void migrateHttpClientAuthenticationConfiguration(NestedAttributesMap httpClientConfg, Map<String, Object> input) {
        if ("username".equals(input.get(REMOTE_AUTH_TYPE))) {
            NestedAttributesMap authConfig = httpClientConfg.child("authentication");
            authConfig.set("type", (Object)"username");
            authConfig.set("username", input.get(REMOTE_AUTH_USERNAME));
            authConfig.set("password", (Object)this.passwordHelper.tryDecrypt((String)input.get(REMOTE_AUTH_PASSWORD)));
        } else if ("ntlm".equals(input.get(REMOTE_AUTH_TYPE))) {
            NestedAttributesMap authConfig = httpClientConfg.child("authentication");
            authConfig.set("type", (Object)"ntlm");
            authConfig.set("username", input.get(REMOTE_AUTH_USERNAME));
            authConfig.set("password", (Object)this.passwordHelper.tryDecrypt((String)input.get(REMOTE_AUTH_PASSWORD)));
            authConfig.set("ntlmHost", input.get(REMOTE_AUTH_NTLM_HOST));
            authConfig.set("ntlmDomain", input.get(REMOTE_AUTH_NTLM_DOMAIN));
        }
    }

    private void migrateFirewallConfiguration(Configuration config, Map<String, Object> input) {
        if (Boolean.TRUE.equals(input.get(AUDIT_ENABLED_KEY))) {
            NestedAttributesMap firewallConfig = config.attributes("firewall");
            firewallConfig.set(AUDIT_ENABLED_KEY, (Object)Boolean.TRUE.toString());
            firewallConfig.set(AUDIT_TIMESTAMP_KEY, (Object)this.toStringOrNull(input.get(AUDIT_TIMESTAMP_KEY)));
            firewallConfig.set(QUARANTINE_ENABLED_TIMESTAMP_KEY, (Object)this.toStringOrNull(input.get(QUARANTINE_ENABLED_TIMESTAMP_KEY)));
            firewallConfig.set("quarantineLastUpdateTimestamp", (Object)this.toStringOrNull(input.get(QUARANTINE_LAST_UPDATED_TIMESTAMP_KEY)));
        }
    }

    private String toStringOrNull(Object value) {
        return value != null ? value.toString() : null;
    }

    @Inject
    public void setPasswordHelper(PasswordHelper passwordHelper) {
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
    }
}

