/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.MigrationService;
import com.sonatype.nexus.migration.assistant.MigrationPhases;
import com.sonatype.nexus.migration.client.RepositoryClient;
import com.sonatype.nexus.migration.client.RepositoryMigrationClient;
import com.sonatype.nexus.migration.firewall.FirewallMigrationFacade;
import com.sonatype.nexus.migration.plan.Step;
import com.sonatype.nexus.migration.plan.StepContext;
import com.sonatype.nexus.migration.repository.IngestMethod;
import com.sonatype.nexus.migration.repository.IngestionValidation;
import com.sonatype.nexus.migration.repository.RepositoryMigrationManager;
import com.sonatype.nexus.migration.repository.RepositoryMigrationResetStep;
import com.sonatype.nexus.migration.repository.RepositoryMigrator;
import com.sonatype.nexus.migration.repository.RepositoryStepSupport;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.ConfigurationConstants;
import org.sonatype.nexus.upgrade.plan.Dependency;

public abstract class RepositoryPrepareStep
extends RepositoryStepSupport {
    public static final String TYPE_NAME = "migration.repository";
    public static final String MIGRATION = "migration";
    public static final String RHC_CONFIGURED = "rhcConfigured";
    public static final String RHC_ENABLED = "rhcEnabled";
    @Inject
    private MigrationService migrationService;
    @Inject
    private RepositoryMigrationManager repositoryMigrationManager;
    @Inject
    private RepositoryClient repositoryClient;
    @Inject
    private RepositoryMigrationClient repositoryMigrationClient;
    @Inject
    private IngestionValidation ingestionValidation;
    @Inject
    private FirewallMigrationFacade firewallMigrationFacade;
    private String dataStoreName;
    private String blobStoreName;
    private IngestMethod ingestMethod;
    private RepositoryMigrator migrator;
    private Repository repository;
    private static Dependency<Step> resetDependency;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public RepositoryPrepareStep() {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
    }

    @Override
    public String getType() {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        return TYPE_NAME;
    }

    @Override
    protected void doConfigure(Map<String, Object> config) {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        Object object = callSiteArray[0].callGetProperty(MigrationPhases.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, RepositoryPrepareStep.class, (GroovyObject)this, (String)"phase");
        String string = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[1].callGetProperty(config), String.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, RepositoryPrepareStep.class, (GroovyObject)this, (String)"repositoryName");
        String string2 = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[2].callGetProperty(config), String.class);
        this.dataStoreName = ShortTypeHandling.castToString((Object)string2);
        String string3 = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[3].callGetProperty(config), String.class);
        this.blobStoreName = ShortTypeHandling.castToString((Object)string3);
        IngestMethod ingestMethod = (IngestMethod)((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[4].callGetProperty(config), IngestMethod.class));
        this.ingestMethod = (IngestMethod)ShortTypeHandling.castToEnum((Object)((Object)ingestMethod), IngestMethod.class);
        Object object2 = callSiteArray[5].callGetProperty(config);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object2, RepositoryPrepareStep.class, (GroovyObject)this, (String)"selectedRepositories");
        GStringImpl gStringImpl = new GStringImpl(new Object[]{callSiteArray[6].callGetProperty(config)}, new String[]{"Prepare repository for upgrade: ", ""});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)gStringImpl, RepositoryPrepareStep.class, (GroovyObject)this, (String)"name");
    }

    @Override
    protected void doInit() {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        Object repo = callSiteArray[7].call(callSiteArray[8].callGroovyObjectGetProperty((Object)this), callSiteArray[9].callGroovyObjectGetProperty((Object)this));
        callSiteArray[10].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareEqual((Object)repo, null), (Object)"Repository already exists: %s", callSiteArray[11].callGroovyObjectGetProperty((Object)this));
        Object object = callSiteArray[12].call((Object)this.repositoryClient, callSiteArray[13].callGetProperty((Object)this.migrationService), callSiteArray[14].callGroovyObjectGetProperty((Object)this));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)((RepositoryClient.RepositoryDetailXO)ScriptBytecodeAdapter.castToType((Object)object, RepositoryClient.RepositoryDetailXO.class)), RepositoryPrepareStep.class, (GroovyObject)this, (String)"repositoryDetail");
        callSiteArray[15].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[16].callGroovyObjectGetProperty((Object)this), null), (Object)"Failed to fetch repository details from remote agent");
        callSiteArray[17].call(callSiteArray[18].callGroovyObjectGetProperty((Object)this), (Object)"Fetched repository details for {}: {}", callSiteArray[19].callGroovyObjectGetProperty((Object)this), callSiteArray[20].callGroovyObjectGetProperty((Object)this));
        Object availableMethods = callSiteArray[21].call((Object)this.ingestionValidation, callSiteArray[22].callGroovyObjectGetProperty((Object)this), (Object)this.blobStoreName);
        callSiteArray[23].callStatic(Preconditions.class, ArrayUtil.createArray((Object)ScriptBytecodeAdapter.isCase((Object)((Object)this.ingestMethod), (Object)availableMethods), (Object)"Ingestion method %s unavailable from repository %s to blob store %s. Allowed: %s", (Object)((Object)this.ingestMethod), (Object)callSiteArray[24].callGroovyObjectGetProperty((Object)this), (Object)this.blobStoreName, (Object)callSiteArray[25].call(Arrays.class, availableMethods)));
        callSiteArray[26].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.getMethodPointer((Object)((Object)this), (String)"prepared"));
        callSiteArray[27].call(callSiteArray[28].callGroovyObjectGetProperty((Object)this), resetDependency);
    }

    @Override
    protected void doRun() {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[29].callGroovyObjectGetProperty((Object)this))) {
            GStringImpl msg = new GStringImpl(new Object[]{callSiteArray[30].callGroovyObjectGetProperty((Object)this)}, new String[]{"Group repository would be empty and will not be created: ", ""});
            callSiteArray[31].call(callSiteArray[32].callGroovyObjectGetProperty((Object)this), (Object)msg);
            callSiteArray[33].call(callSiteArray[34].callGetProperty(StepContext.class), (Object)msg);
        } else {
            Object assistant = callSiteArray[35].callGetProperty((Object)this.migrationService);
            Object format = callSiteArray[36].callGroovyObjectGetProperty(callSiteArray[37].callGroovyObjectGetProperty((Object)this));
            Object type = callSiteArray[38].callGroovyObjectGetProperty(callSiteArray[39].callGroovyObjectGetProperty((Object)this));
            Object configurationFactory = callSiteArray[40].call((Object)this.repositoryMigrationManager, format, type);
            callSiteArray[41].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareNotEqual((Object)configurationFactory, null), (Object)"Missing repository-configuration factory: %s-%s", format, type);
            Object repositoryConfig = callSiteArray[42].call(configurationFactory, callSiteArray[43].callGroovyObjectGetProperty(callSiteArray[44].callGroovyObjectGetProperty((Object)this)));
            Object object = callSiteArray[45].callGroovyObjectGetProperty((Object)this);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)repositoryConfig, (String)"repositoryName");
            callSiteArray[46].call(callSiteArray[47].call(repositoryConfig, callSiteArray[48].callGetProperty(ConfigurationConstants.class)), callSiteArray[49].callGetProperty(ConfigurationConstants.class), (Object)this.dataStoreName);
            callSiteArray[50].call(callSiteArray[51].call(repositoryConfig, callSiteArray[52].callGetProperty(ConfigurationConstants.class)), callSiteArray[53].callGetProperty(ConfigurationConstants.class), (Object)this.blobStoreName);
            boolean bl = false;
            ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)repositoryConfig, (String)"online");
            Object object2 = callSiteArray[54].call(callSiteArray[55].callGroovyObjectGetProperty((Object)this), repositoryConfig);
            this.repository = (Repository)ScriptBytecodeAdapter.castToType((Object)object2, Repository.class);
            callSiteArray[56].callCurrent((GroovyObject)this, (Object)this.repository);
            callSiteArray[57].callCurrent((GroovyObject)this, (Object)this.repository, callSiteArray[58].callGroovyObjectGetProperty((Object)this));
            callSiteArray[59].call((Object)this.firewallMigrationFacade, (Object)this.repository, callSiteArray[60].callGroovyObjectGetProperty((Object)this));
            callSiteArray[61].call((Object)this.repositoryMigrationClient, assistant, callSiteArray[62].callGroovyObjectGetProperty((Object)this));
            callSiteArray[63].call((Object)this.repositoryMigrationClient, assistant, callSiteArray[64].callGroovyObjectGetProperty((Object)this));
            Object object3 = callSiteArray[65].call((Object)this.repositoryMigrationManager, assistant, callSiteArray[66].callGroovyObjectGetProperty((Object)this), (Object)this.ingestMethod);
            this.migrator = (RepositoryMigrator)ScriptBytecodeAdapter.castToType((Object)object3, RepositoryMigrator.class);
        }
    }

    protected abstract void allowWrite(Repository var1);

    protected abstract void recordRepositoryHealthCheckStatus(Repository var1, RepositoryClient.RepositoryDetailXO var2);

    @Override
    protected void doAbort() {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)this.repository)) {
            callSiteArray[67].call(callSiteArray[68].callGroovyObjectGetProperty((Object)this), callSiteArray[69].callGroovyObjectGetProperty((Object)this));
        }
        callSiteArray[70].call((Object)this.repositoryMigrationClient, callSiteArray[71].callGetProperty((Object)this.migrationService), callSiteArray[72].callGroovyObjectGetProperty((Object)this));
        callSiteArray[73].call((Object)this.repositoryMigrationManager, callSiteArray[74].callGroovyObjectGetProperty((Object)this));
    }

    @Override
    protected void doDestroy() {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        Object var2_2 = null;
        this.repository = (Repository)ScriptBytecodeAdapter.castToType(var2_2, Repository.class);
        Object var3_3 = null;
        this.migrator = (RepositoryMigrator)ScriptBytecodeAdapter.castToType(var3_3, RepositoryMigrator.class);
    }

    public static Dependency<Step> prepared(String repositoryName) {
        Reference repositoryName2 = new Reference((Object)repositoryName);
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        return new Dependency<Step>(RepositoryPrepareStep.class, repositoryName2){
            public /* synthetic */ Reference repositoryName;
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                Reference reference;
                Class clazz;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0 = clazz = p0;
                this.repositoryName = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public boolean satisfiedBy(Step other) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return other instanceof RepositoryPrepareStep ? ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty((Object)other), (Object)this.repositoryName.get()) : false;
            }

            public String toString() {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.repositoryName.get()}, new String[]{"REPOSITORY-PREPARED(", ")"}));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, RepositoryPrepareStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, RepositoryPrepareStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, RepositoryPrepareStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, RepositoryPrepareStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, RepositoryPrepareStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, RepositoryPrepareStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "repositoryName";
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        };
    }

    public /* synthetic */ Object this$dist$invoke$4(String name, Object args) {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(RepositoryPrepareStep.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$4(String name, Object value) {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, RepositoryPrepareStep.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$4(String name) {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(RepositoryPrepareStep.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != RepositoryPrepareStep.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        2 var0;
        resetDependency = var0 = new 2(RepositoryPrepareStep.class);
    }

    public MigrationService getMigrationService() {
        return this.migrationService;
    }

    public void setMigrationService(MigrationService migrationService) {
        this.migrationService = migrationService;
    }

    public RepositoryMigrationManager getRepositoryMigrationManager() {
        return this.repositoryMigrationManager;
    }

    public void setRepositoryMigrationManager(RepositoryMigrationManager repositoryMigrationManager) {
        this.repositoryMigrationManager = repositoryMigrationManager;
    }

    public RepositoryClient getRepositoryClient() {
        return this.repositoryClient;
    }

    public void setRepositoryClient(RepositoryClient repositoryClient) {
        this.repositoryClient = repositoryClient;
    }

    public RepositoryMigrationClient getRepositoryMigrationClient() {
        return this.repositoryMigrationClient;
    }

    public void setRepositoryMigrationClient(RepositoryMigrationClient repositoryMigrationClient) {
        this.repositoryMigrationClient = repositoryMigrationClient;
    }

    public IngestionValidation getIngestionValidation() {
        return this.ingestionValidation;
    }

    public void setIngestionValidation(IngestionValidation ingestionValidation) {
        this.ingestionValidation = ingestionValidation;
    }

    public FirewallMigrationFacade getFirewallMigrationFacade() {
        return this.firewallMigrationFacade;
    }

    public void setFirewallMigrationFacade(FirewallMigrationFacade firewallMigrationFacade) {
        this.firewallMigrationFacade = firewallMigrationFacade;
    }

    public static Dependency<Step> getResetDependency() {
        return resetDependency;
    }

    public static void setResetDependency(Dependency<Step> dependency) {
        resetDependency = dependency;
    }

    public /* synthetic */ void super$3$doConfigure(Map map) {
        super.doConfigure(map);
    }

    public /* synthetic */ void super$3$doInit() {
        super.doInit();
    }

    public /* synthetic */ void super$3$doAbort() {
        super.doAbort();
    }

    public /* synthetic */ void super$3$doDestroy() {
        super.doDestroy();
    }

    public /* synthetic */ MetaClass super$4$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "PREPARE";
        stringArray[1] = "repository";
        stringArray[2] = "dataStore";
        stringArray[3] = "blobStore";
        stringArray[4] = "ingestMethod";
        stringArray[5] = "selectedRepositories";
        stringArray[6] = "repository";
        stringArray[7] = "get";
        stringArray[8] = "repositoryManager";
        stringArray[9] = "repositoryName";
        stringArray[10] = "checkState";
        stringArray[11] = "repositoryName";
        stringArray[12] = "get";
        stringArray[13] = "assistant";
        stringArray[14] = "repositoryName";
        stringArray[15] = "checkState";
        stringArray[16] = "repositoryDetail";
        stringArray[17] = "debug";
        stringArray[18] = "log";
        stringArray[19] = "repositoryName";
        stringArray[20] = "repositoryDetail";
        stringArray[21] = "availableMethods";
        stringArray[22] = "repositoryName";
        stringArray[23] = "checkState";
        stringArray[24] = "repositoryName";
        stringArray[25] = "toString";
        stringArray[26] = "adjustGroupMembersAndDependencies";
        stringArray[27] = "leftShift";
        stringArray[28] = "dependencies";
        stringArray[29] = "emptyGroup";
        stringArray[30] = "repositoryName";
        stringArray[31] = "warn";
        stringArray[32] = "log";
        stringArray[33] = "log";
        stringArray[34] = "current";
        stringArray[35] = "assistant";
        stringArray[36] = "format";
        stringArray[37] = "repositoryDetail";
        stringArray[38] = "type";
        stringArray[39] = "repositoryDetail";
        stringArray[40] = "findConfigurationFactory";
        stringArray[41] = "checkState";
        stringArray[42] = "create";
        stringArray[43] = "attributes";
        stringArray[44] = "repositoryDetail";
        stringArray[45] = "repositoryName";
        stringArray[46] = "set";
        stringArray[47] = "attributes";
        stringArray[48] = "STORAGE";
        stringArray[49] = "DATA_STORE_NAME";
        stringArray[50] = "set";
        stringArray[51] = "attributes";
        stringArray[52] = "STORAGE";
        stringArray[53] = "BLOB_STORE_NAME";
        stringArray[54] = "create";
        stringArray[55] = "repositoryManager";
        stringArray[56] = "allowWrite";
        stringArray[57] = "recordRepositoryHealthCheckStatus";
        stringArray[58] = "repositoryDetail";
        stringArray[59] = "maybeRecordRepositoryFirewallAttributes";
        stringArray[60] = "repositoryDetail";
        stringArray[61] = "begin";
        stringArray[62] = "repositoryName";
        stringArray[63] = "initiate";
        stringArray[64] = "repositoryName";
        stringArray[65] = "createMigrator";
        stringArray[66] = "repositoryName";
        stringArray[67] = "delete";
        stringArray[68] = "repositoryManager";
        stringArray[69] = "repositoryName";
        stringArray[70] = "finish";
        stringArray[71] = "assistant";
        stringArray[72] = "repositoryName";
        stringArray[73] = "removeMigrator";
        stringArray[74] = "repositoryName";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[75];
        RepositoryPrepareStep.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(RepositoryPrepareStep.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = RepositoryPrepareStep.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    class 2
    implements Dependency<Step>,
    GroovyObject {
        public /* synthetic */ Class this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        /* synthetic */ 2(Class p0) {
            MetaClass metaClass;
            Class clazz;
            CallSite[] callSiteArray = 2.$getCallSiteArray();
            this.this$0 = clazz = p0;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public boolean satisfiedBy(Step other) {
            CallSite[] callSiteArray = 2.$getCallSiteArray();
            return other instanceof RepositoryMigrationResetStep;
        }

        public String toString() {
            CallSite[] callSiteArray = 2.$getCallSiteArray();
            return "REPOSITORY-MIGRATION-RESET";
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = 2.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(2.class, RepositoryPrepareStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = 2.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(2.class, RepositoryPrepareStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = 2.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, RepositoryPrepareStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = 2.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, RepositoryPrepareStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = 2.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(2.class, RepositoryPrepareStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = 2.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(2.class, RepositoryPrepareStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != 2.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(2.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = 2.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

