/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.migration.MigrationService;
import com.sonatype.nexus.migration.assistant.MigrationPhases;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.client.http.MigrationDisconnectionEvent;
import com.sonatype.nexus.migration.client.http.MigrationReconnectionEvent;
import com.sonatype.nexus.migration.client.http.RequestMonitorController;
import com.sonatype.nexus.migration.plan.Step;
import com.sonatype.nexus.migration.repository.BufferingIterator;
import com.sonatype.nexus.migration.repository.CompletionOrderHelper;
import com.sonatype.nexus.migration.repository.RepositoryMigrationManager;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.time.TimeCategory;
import groovy.time.TimeDuration;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.security.subject.FakeAlmightySubject;
import org.sonatype.nexus.thread.NexusExecutorService;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Named(value="migration.process-changes")
public class ProcessChangesStep
extends Step {
    public static final String TYPE_NAME = "migration.process-changes";
    public static final int DEFAULT_PROCESSING_THREADS;
    private static final Time ADDITIONAL_CHANGES_CHECK_DELAY;
    @Inject
    @Named(value="${nexus.migration.repositories.skip.content}")
    @Nullable
    private String repositoriesContentSkipProperty;
    @Inject
    private MigrationService migrationService;
    @Inject
    private RepositoryMigrationManager repositoryMigrationManager;
    @Inject
    private RepositoryChangelogClient repositoryChangelogClient;
    @Inject
    private RequestMonitorController httpController;
    @Inject
    private EventManager eventManager;
    private RepositoryChangelogClient.ChangelogConnection changelogConnection;
    private AtomicReference<String> lastProcessedChangeId;
    private ExecutorService processingThreads;
    private BlockingQueue<ProcessingResult> results;
    private final CompletionOrderHelper<String> completionOrder;
    private int totalCount;
    private int threadCount;
    private int failedCount;
    private AtomicBoolean waitingForChanges;
    private AtomicBoolean stopWaiting;
    private Set<String> repositoriesContentSkip;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ProcessChangesStep() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        Object object = callSiteArray[0].callConstructor(AtomicReference.class);
        this.lastProcessedChangeId = (AtomicReference)ScriptBytecodeAdapter.castToType((Object)object, AtomicReference.class);
        Object object2 = callSiteArray[1].callConstructor(CompletionOrderHelper.class);
        this.completionOrder = (CompletionOrderHelper)ScriptBytecodeAdapter.castToType((Object)object2, CompletionOrderHelper.class);
        Object object3 = callSiteArray[2].callConstructor(AtomicBoolean.class, (Object)false);
        this.waitingForChanges = (AtomicBoolean)ScriptBytecodeAdapter.castToType((Object)object3, AtomicBoolean.class);
        Object object4 = callSiteArray[3].callConstructor(AtomicBoolean.class, (Object)false);
        this.stopWaiting = (AtomicBoolean)ScriptBytecodeAdapter.castToType((Object)object4, AtomicBoolean.class);
    }

    @Override
    public String getType() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        return TYPE_NAME;
    }

    @Override
    protected void doConfigure(Map<String, Object> config) {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        Object object = callSiteArray[4].callGetProperty(MigrationPhases.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ProcessChangesStep.class, (GroovyObject)this, (String)"phase");
        String string = "Process changes";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, ProcessChangesStep.class, (GroovyObject)this, (String)"name");
    }

    @Override
    protected void doInit() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        Object assistant = callSiteArray[5].callGetProperty((Object)this.migrationService);
        Object object = callSiteArray[6].call((Object)this.repositoryChangelogClient, assistant);
        this.changelogConnection = (RepositoryChangelogClient.ChangelogConnection)ScriptBytecodeAdapter.castToType((Object)object, RepositoryChangelogClient.ChangelogConnection.class);
        Object object2 = callSiteArray[7].call(SystemPropertiesHelper.class, callSiteArray[8].call(callSiteArray[9].callGetProperty(ProcessChangesStep.class), (Object)".threads"), (Object)DEFAULT_PROCESSING_THREADS);
        this.threadCount = DefaultTypeTransformation.intUnbox((Object)object2);
        callSiteArray[10].call(callSiteArray[11].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{this.threadCount}, new String[]{"Processing changes using ", " threads"}));
        Object object3 = callSiteArray[12].call(NexusExecutorService.class, callSiteArray[13].call(Executors.class, (Object)this.threadCount, callSiteArray[14].callConstructor(NexusThreadFactory.class, (Object)"change-processing", (Object)"migration")), callSiteArray[15].callGetProperty(FakeAlmightySubject.class));
        this.processingThreads = (ExecutorService)ScriptBytecodeAdapter.castToType((Object)object3, ExecutorService.class);
        Object object4 = callSiteArray[16].callConstructor(ArrayBlockingQueue.class, (Object)this.threadCount);
        this.results = (BlockingQueue)ScriptBytecodeAdapter.castToType((Object)object4, BlockingQueue.class);
        callSiteArray[17].call((Object)this.eventManager, (Object)this);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object5 = callSiteArray[18].callCurrent((GroovyObject)this);
            this.repositoriesContentSkip = (Set)ScriptBytecodeAdapter.castToType((Object)object5, Set.class);
        } else {
            Set<String> set = this.getRepositoriesContentSkip();
            this.repositoriesContentSkip = set;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[19].callGetProperty(this.repositoriesContentSkip))) {
            callSiteArray[20].call(callSiteArray[21].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{this.repositoriesContentSkip}, new String[]{"The following repositories will have configuration migrated but no content: ", ""}));
        }
    }

    private Set<String> getRepositoriesContentSkip() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)this.repositoriesContentSkipProperty, null)) {
            return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].call(Collections.class), Set.class);
        }
        String[] arr = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].call((Object)this.repositoriesContentSkipProperty, (Object)","), String[].class);
        public class _getRepositoriesContentSkip_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getRepositoriesContentSkip_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getRepositoriesContentSkip_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getRepositoriesContentSkip_closure1.$getCallSiteArray();
                return callSiteArray[0].call(it);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getRepositoriesContentSkip_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getRepositoriesContentSkip_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "trim";
                return new CallSiteArray(_getRepositoriesContentSkip_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getRepositoriesContentSkip_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].call(callSiteArray[25].call(callSiteArray[26].call(Arrays.class, (Object)arr), (Object)new _getRepositoriesContentSkip_closure1((Object)this, (Object)this)), callSiteArray[27].call(Collectors.class)), Set.class);
    }

    @Override
    protected void doDestroy() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)this.changelogConnection)) {
            callSiteArray[28].call((Object)this.changelogConnection);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.processingThreads)) {
            callSiteArray[29].call((Object)this.processingThreads);
        }
        callSiteArray[30].call((Object)this.eventManager, (Object)this);
    }

    @Override
    protected void doRun() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        try {
            boolean bl = true;
            ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)this.httpController, (String)"indefiniteRetry");
            long timestamp = DefaultTypeTransformation.longUnbox((Object)callSiteArray[31].call(System.class));
            while (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[32].callCurrent((GroovyObject)this))) {
                long count = DefaultTypeTransformation.longUnbox((Object)callSiteArray[33].callCurrent((GroovyObject)this));
                long now = DefaultTypeTransformation.longUnbox((Object)callSiteArray[34].call(System.class));
                if (count > 0L) {
                    long l;
                    timestamp = l = now;
                }
                callSiteArray[35].call(callSiteArray[36].callGroovyObjectGetProperty((Object)this), (Object)"Waiting for more changes");
                Object elapsed = callSiteArray[37].callCurrent((GroovyObject)this, callSiteArray[38].call(TimeCategory.class, callSiteArray[39].callConstructor(Date.class, (Object)now), callSiteArray[40].callConstructor(Date.class, (Object)timestamp)));
                GStringImpl gStringImpl = new GStringImpl(new Object[]{this.totalCount, callSiteArray[41].callCurrent((GroovyObject)this), elapsed}, new String[]{"", " processed ", ", ", " since last change, press \"Continue\" when ready"});
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)ShortTypeHandling.castToString((Object)gStringImpl), ProcessChangesStep.class, (GroovyObject)this, (String)"status");
                callSiteArray[42].call((Object)ADDITIONAL_CHANGES_CHECK_DELAY);
            }
        }
        finally {
            boolean bl = false;
            ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)this.httpController, (String)"indefiniteRetry");
        }
    }

    @Override
    protected void doAbort() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        boolean bl = false;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)this.httpController, (String)"indefiniteRetry");
    }

    public String simplify(TimeDuration duration) {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        String days = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[43].callGetProperty((Object)duration), (Object)1) ? "1 day" : new GStringImpl(new Object[]{callSiteArray[44].callGetProperty((Object)duration)}, new String[]{"", " days"});
        String hours = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[45].callGetProperty((Object)duration), (Object)1) ? "1 hour" : new GStringImpl(new Object[]{callSiteArray[46].callGetProperty((Object)duration)}, new String[]{"", " hours"});
        String minutes = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[47].callGetProperty((Object)duration), (Object)1) ? "1 minute" : new GStringImpl(new Object[]{callSiteArray[48].callGetProperty((Object)duration)}, new String[]{"", " minutes"});
        String seconds = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[49].callGetProperty((Object)duration), (Object)1) ? "1 second" : new GStringImpl(new Object[]{callSiteArray[50].callGetProperty((Object)duration)}, new String[]{"", " seconds"});
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[51].callGetProperty((Object)duration), (Object)0)) {
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{days, hours}, new String[]{"", " ", ""}));
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[52].callGetProperty((Object)duration), (Object)0)) {
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{hours, minutes}, new String[]{"", " ", ""}));
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[53].callGetProperty((Object)duration), (Object)0)) {
            return ShortTypeHandling.castToString((Object)minutes);
        }
        return ShortTypeHandling.castToString((Object)seconds);
    }

    private boolean shouldRun() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[54].callGroovyObjectGetProperty((Object)this)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[55].call((Object)this.stopWaiting));
        }
        return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[56].callGroovyObjectGetProperty((Object)this)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[57].call((Object)this.stopWaiting));
    }

    public boolean isWaiting() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[58].call((Object)this.waitingForChanges));
    }

    public boolean stopWaiting() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[59].callGetProperty((Object)this.migrationService)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[60].call((Object)this.waitingForChanges))) {
            callSiteArray[61].call((Object)this.stopWaiting, (Object)true);
            return true;
        }
        return false;
    }

    public long sync() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        Set pathsInUse = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[62].callConstructor(HashSet.class), Set.class);
        Reference lastProcessedChangeId = new Reference(this.lastProcessedChangeId);
        public class _sync_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference lastProcessedChangeId;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _sync_closure2(Object _outerInstance, Object _thisObject, Reference lastProcessedChangeId) {
                Reference reference;
                CallSite[] callSiteArray = _sync_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.lastProcessedChangeId = reference = lastProcessedChangeId;
            }

            public Object doCall(Object completedId) {
                CallSite[] callSiteArray = _sync_closure2.$getCallSiteArray();
                return callSiteArray[0].call(this.lastProcessedChangeId.get(), completedId);
            }

            public Object getLastProcessedChangeId() {
                CallSite[] callSiteArray = _sync_closure2.$getCallSiteArray();
                return this.lastProcessedChangeId.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _sync_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "set";
                return new CallSiteArray(_sync_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _sync_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[63].call(this.completionOrder, (Object)new _sync_closure2((Object)this, (Object)this, lastProcessedChangeId));
        int count = 0;
        Object iterator = callSiteArray[64].call(callSiteArray[65].callCurrent((GroovyObject)this, callSiteArray[66].call(lastProcessedChangeId.get()), callSiteArray[67].callGetProperty(callSiteArray[68].callGetProperty((Object)this.migrationService))));
        PeekingIterator changes = (PeekingIterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].call(Iterators.class, iterator), PeekingIterator.class);
        boolean pathContention = false;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[70].call((Object)changes))) {
            callSiteArray[71].call(callSiteArray[72].callGroovyObjectGetProperty((Object)this), (Object)"ProcessChangesStep has found changes to process so will STOP waiting for changes from nxrm2 until processing complete");
            callSiteArray[73].call((Object)this.waitingForChanges, (Object)false);
        }
        while (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[74].call((Object)changes)) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[75].call((Object)pathsInUse))) {
            callSiteArray[76].call(callSiteArray[77].callGroovyObjectGetProperty((Object)this), callSiteArray[78].call(callSiteArray[79].call(callSiteArray[80].call((Object)"Processing changes from changesIterator:", callSiteArray[81].call((Object)changes)), (Object)" or from pathsInUse: "), callSiteArray[82].call((Object)pathsInUse)));
            GStringImpl gStringImpl = new GStringImpl(new Object[]{this.totalCount, callSiteArray[83].callCurrent((GroovyObject)this)}, new String[]{"Processed ", " items ", "..."});
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)ShortTypeHandling.castToString((Object)gStringImpl), ProcessChangesStep.class, (GroovyObject)this, (String)"status");
            while (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[84].call((Object)changes)) && !pathContention && ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[85].call((Object)pathsInUse), (Object)this.threadCount)) {
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[86].callCurrent((GroovyObject)this))) {
                    callSiteArray[87].call(callSiteArray[88].callGroovyObjectGetProperty((Object)this), (Object)"Request to forcefully stop sync phase");
                    callSiteArray[89].call(callSiteArray[90].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{this.totalCount, this.failedCount}, new String[]{"Sync phase was stopped after ", " total items processed, with ", " items failed. "}));
                    GStringImpl gStringImpl2 = new GStringImpl(new Object[]{this.totalCount, callSiteArray[91].callCurrent((GroovyObject)this)}, new String[]{"Sync phase was stopped after ", " total items ", "... "});
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)ShortTypeHandling.castToString((Object)gStringImpl2), ProcessChangesStep.class, (GroovyObject)this, (String)"status");
                    break;
                }
                Object nextChange = callSiteArray[92].call((Object)changes);
                Object repositoryId = callSiteArray[93].callGetProperty(nextChange);
                if (ScriptBytecodeAdapter.isCase((Object)repositoryId, this.repositoriesContentSkip)) {
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[94].call(callSiteArray[95].callGroovyObjectGetProperty((Object)this)))) {
                        callSiteArray[96].call(callSiteArray[97].callGroovyObjectGetProperty((Object)this), (Object)"ProcessChangesStep for the change type {}, component {} in the repository {} is skipped", callSiteArray[98].callGetProperty(callSiteArray[99].callGetProperty(nextChange)), callSiteArray[100].callGetProperty(callSiteArray[101].callGetProperty(nextChange)), repositoryId);
                    }
                    callSiteArray[102].call((Object)changes);
                    continue;
                }
                Object path = callSiteArray[103].callCurrent((GroovyObject)this, nextChange);
                if (ScriptBytecodeAdapter.isCase((Object)path, (Object)pathsInUse)) {
                    boolean bl;
                    pathContention = bl = true;
                    continue;
                }
                callSiteArray[104].call((Object)pathsInUse, path);
                callSiteArray[105].callCurrent((GroovyObject)this, nextChange);
                callSiteArray[106].call((Object)changes);
                int n = this.totalCount;
                this.totalCount = DefaultTypeTransformation.intUnbox((Object)callSiteArray[107].call((Object)n));
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[108].callCurrent((GroovyObject)this))) break;
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[109].call((Object)pathsInUse))) {
                Object result = callSiteArray[110].call(this.results);
                Object resultPath = callSiteArray[111].callGetProperty(result);
                callSiteArray[112].call((Object)pathsInUse, resultPath);
                Object nextChange = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[113].call((Object)changes)) ? callSiteArray[114].call((Object)changes) : null;
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[115].callCurrent((GroovyObject)this, nextChange), (Object)resultPath)) {
                    boolean bl;
                    pathContention = bl = false;
                }
                int n = count;
                count = DefaultTypeTransformation.intUnbox((Object)callSiteArray[116].call((Object)n));
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[117].callGetProperty(result))) {
                    String repositoryId = ShortTypeHandling.castToString((Object)callSiteArray[118].callGetProperty(result));
                    Object changeType = callSiteArray[119].callGetProperty(result);
                    Object e = callSiteArray[120].callGetProperty(result);
                    callSiteArray[121].call(callSiteArray[122].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)"Failed processing of %s %s:%s.  %s", (Object)changeType, (Object)repositoryId, (Object)resultPath, (Object)callSiteArray[123].callGetProperty(e)));
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[124].call(callSiteArray[125].callGroovyObjectGetProperty((Object)this)))) {
                        callSiteArray[126].call(callSiteArray[127].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)"Failed processing of {} {}:{}, will ignore and move on. {}", (Object)changeType, (Object)repositoryId, (Object)resultPath, (Object)callSiteArray[128].callGetProperty(e), (Object)e));
                    } else {
                        callSiteArray[129].call(callSiteArray[130].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)"Failed processing of {} {}:{}, will ignore and move on. {}", (Object)changeType, (Object)repositoryId, (Object)resultPath, (Object)callSiteArray[131].callGetProperty(e)));
                    }
                    int n2 = this.failedCount;
                    this.failedCount = DefaultTypeTransformation.intUnbox((Object)callSiteArray[132].call((Object)n2));
                }
            }
            GStringImpl gStringImpl3 = new GStringImpl(new Object[]{this.totalCount, callSiteArray[133].callCurrent((GroovyObject)this)}, new String[]{"Processed ", " items ", "..."});
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)ShortTypeHandling.castToString((Object)gStringImpl3), ProcessChangesStep.class, (GroovyObject)this, (String)"status");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[134].call((Object)this.stopWaiting))) {
            callSiteArray[135].call(callSiteArray[136].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{this.totalCount, this.failedCount}, new String[]{"Sync phase was stopped after ", " total items processed, with ", " items failed."}));
        } else {
            callSiteArray[137].call(callSiteArray[138].callGroovyObjectGetProperty((Object)this), (Object)"ProcessChangesStep has completed processing changes from nxrm2 so will START waiting for more changes from nxrm2");
        }
        callSiteArray[139].call((Object)this.waitingForChanges, (Object)true);
        return count;
    }

    @Nullable
    public String calculatePath(@Nullable RepositoryChangelogClient.ChangeEntryXO change) {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)change)) {
            return ShortTypeHandling.castToString(null);
        }
        Object migrator = callSiteArray[140].call((Object)this.repositoryMigrationManager, callSiteArray[141].callGroovyObjectGetProperty((Object)change));
        if (!DefaultTypeTransformation.booleanUnbox((Object)migrator)) {
            return ShortTypeHandling.castToString((Object)callSiteArray[142].callGetProperty(callSiteArray[143].callGroovyObjectGetProperty((Object)change)));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[144].call(migrator, (Object)change));
    }

    private String failedText() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        if (this.failedCount != 0) {
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.failedCount}, new String[]{" <a href=\"#\" onclick=\"return false;\">(", " failed)</a>"}));
        }
        return "";
    }

    private void submit(RepositoryChangelogClient.ChangeEntryXO change) {
        Reference change2 = new Reference((Object)change);
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        callSiteArray[145].call(this.completionOrder, callSiteArray[146].callGroovyObjectGetProperty((Object)((RepositoryChangelogClient.ChangeEntryXO)change2.get())));
        Reference resultQueue = new Reference(this.results);
        Reference order = new Reference(this.completionOrder);
        public class _submit_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference change;
            private /* synthetic */ Reference resultQueue;
            private /* synthetic */ Reference order;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _submit_closure3(Object _outerInstance, Object _thisObject, Reference change, Reference resultQueue, Reference order) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _submit_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.change = reference3 = change;
                this.resultQueue = reference2 = resultQueue;
                this.order = reference = order;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _submit_closure3.$getCallSiteArray();
                callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)"Processing change {}", this.change.get());
                Object migrator = callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty(this.getThisObject()), callSiteArray[4].callGroovyObjectGetProperty(this.change.get()));
                callSiteArray[5].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareNotEqual((Object)migrator, null), (Object)"No migrator found for repository %s", callSiteArray[6].callGroovyObjectGetProperty(this.change.get()));
                callSiteArray[7].call(migrator, this.change.get());
                callSiteArray[8].call(this.resultQueue.get(), callSiteArray[9].callConstructor(ProcessingResult.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"changeId", callSiteArray[10].callGroovyObjectGetProperty(this.change.get()), "changeType", callSiteArray[11].callGetProperty(callSiteArray[12].callGroovyObjectGetProperty(this.change.get())), "repositoryId", callSiteArray[13].callGroovyObjectGetProperty(this.change.get()), "calculatedPath", callSiteArray[14].callCurrent((GroovyObject)this, this.change.get())})));
                Object object = callSiteArray[15].call(this.order.get(), callSiteArray[16].callGroovyObjectGetProperty(this.change.get()));
                try {
                    return object;
                }
                catch (Exception e) {
                    callSiteArray[17].call(this.resultQueue.get(), callSiteArray[18].callConstructor(ProcessingResult.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"changeId", callSiteArray[19].callGroovyObjectGetProperty(this.change.get()), "changeType", callSiteArray[20].callGetProperty(callSiteArray[21].callGroovyObjectGetProperty(this.change.get())), "repositoryId", callSiteArray[22].callGroovyObjectGetProperty(this.change.get()), "calculatedPath", callSiteArray[23].callCurrent((GroovyObject)this, this.change.get()), "exception", e})));
                    Object object2 = callSiteArray[24].call(this.order.get(), callSiteArray[25].callGroovyObjectGetProperty(this.change.get()));
                    return object2;
                }
            }

            public RepositoryChangelogClient.ChangeEntryXO getChange() {
                CallSite[] callSiteArray = _submit_closure3.$getCallSiteArray();
                return (RepositoryChangelogClient.ChangeEntryXO)ScriptBytecodeAdapter.castToType((Object)this.change.get(), RepositoryChangelogClient.ChangeEntryXO.class);
            }

            public BlockingQueue getResultQueue() {
                CallSite[] callSiteArray = _submit_closure3.$getCallSiteArray();
                return (BlockingQueue)ScriptBytecodeAdapter.castToType((Object)this.resultQueue.get(), BlockingQueue.class);
            }

            public CompletionOrderHelper getOrder() {
                CallSite[] callSiteArray = _submit_closure3.$getCallSiteArray();
                return (CompletionOrderHelper)ScriptBytecodeAdapter.castToType((Object)this.order.get(), CompletionOrderHelper.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _submit_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _submit_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "trace";
                stringArray[1] = "log";
                stringArray[2] = "findMigrator";
                stringArray[3] = "repositoryMigrationManager";
                stringArray[4] = "repositoryId";
                stringArray[5] = "checkState";
                stringArray[6] = "repositoryId";
                stringArray[7] = "processChange";
                stringArray[8] = "put";
                stringArray[9] = "<$constructor$>";
                stringArray[10] = "id";
                stringArray[11] = "type";
                stringArray[12] = "change";
                stringArray[13] = "repositoryId";
                stringArray[14] = "calculatePath";
                stringArray[15] = "complete";
                stringArray[16] = "id";
                stringArray[17] = "put";
                stringArray[18] = "<$constructor$>";
                stringArray[19] = "id";
                stringArray[20] = "type";
                stringArray[21] = "change";
                stringArray[22] = "repositoryId";
                stringArray[23] = "calculatePath";
                stringArray[24] = "abort";
                stringArray[25] = "id";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[26];
                _submit_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_submit_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _submit_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[147].call((Object)this.processingThreads, (Object)new _submit_closure3((Object)this, (Object)this, change2, resultQueue, order));
    }

    public Iterable<RepositoryChangelogClient.ChangeEntryXO> after(String afterChangeEntryId, int fetchSize) {
        Reference fetchSize2 = new Reference((Object)fetchSize);
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        Reference nextFetchId = new Reference((Object)afterChangeEntryId);
        public class _after_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference nextFetchId;
            private /* synthetic */ Reference fetchSize;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _after_closure4(Object _outerInstance, Object _thisObject, Reference nextFetchId, Reference fetchSize) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _after_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.nextFetchId = reference2 = nextFetchId;
                this.fetchSize = reference = fetchSize;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _after_closure4.$getCallSiteArray();
                public class _closure5
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference nextFetchId;
                    private /* synthetic */ Reference fetchSize;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure5(Object _outerInstance, Object _thisObject, Reference nextFetchId, Reference fetchSize) {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.nextFetchId = reference2 = nextFetchId;
                        this.fetchSize = reference = fetchSize;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        Object changes = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), this.nextFetchId.get(), this.fetchSize.get());
                        if (DefaultTypeTransformation.booleanUnbox((Object)changes)) {
                            RepositoryChangelogClient.ChangeEntryXO last = (RepositoryChangelogClient.ChangeEntryXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(Iterables.class, changes), RepositoryChangelogClient.ChangeEntryXO.class);
                            Object object = callSiteArray[3].call((Object)last);
                            this.nextFetchId.set(object);
                        }
                        return changes;
                    }

                    public Object getNextFetchId() {
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        return this.nextFetchId.get();
                    }

                    public int getFetchSize() {
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        return DefaultTypeTransformation.intUnbox((Object)this.fetchSize.get());
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "get";
                        stringArray[1] = "changelogConnection";
                        stringArray[2] = "getLast";
                        stringArray[3] = "getId";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[4];
                        _closure5.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure5.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure5.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[0].callConstructor(BufferingIterator.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Supplier)ScriptBytecodeAdapter.asType((Object)((Object)new _closure5((Object)this, this.getThisObject(), this.nextFetchId, this.fetchSize)), Supplier.class)), Supplier.class));
            }

            public Object getNextFetchId() {
                CallSite[] callSiteArray = _after_closure4.$getCallSiteArray();
                return this.nextFetchId.get();
            }

            public int getFetchSize() {
                CallSite[] callSiteArray = _after_closure4.$getCallSiteArray();
                return DefaultTypeTransformation.intUnbox((Object)this.fetchSize.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _after_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _after_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "<$constructor$>";
                return new CallSiteArray(_after_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _after_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Iterable)ScriptBytecodeAdapter.castToType((Object)((Object)new _after_closure4((Object)this, (Object)this, nextFetchId, fetchSize2)), Iterable.class);
    }

    @Subscribe
    public void on(MigrationReconnectionEvent event) {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        String string = "HTTP connection restored";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, ProcessChangesStep.class, (GroovyObject)this, (String)"status");
        callSiteArray[148].call(callSiteArray[149].callGroovyObjectGetProperty((Object)this), (Object)"HTTP connection restored");
    }

    @Subscribe
    public void on(MigrationDisconnectionEvent event) {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        GStringImpl message = new GStringImpl(new Object[]{callSiteArray[150].callGetProperty((Object)event), callSiteArray[151].callGetProperty((Object)event)}, new String[]{"HTTP disconnection: ", ", retrying at ", ""});
        GStringImpl gStringImpl = message;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)gStringImpl, ProcessChangesStep.class, (GroovyObject)this, (String)"status");
        callSiteArray[152].call(callSiteArray[153].callGroovyObjectGetProperty((Object)this), (Object)message);
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ProcessChangesStep.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ProcessChangesStep.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ProcessChangesStep.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != ProcessChangesStep.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Object object = ProcessChangesStep.$getCallSiteArray()[154].call(ProcessChangesStep.$getCallSiteArray()[155].call(Runtime.class));
        DEFAULT_PROCESSING_THREADS = DefaultTypeTransformation.intUnbox((Object)object);
        Object object2 = ProcessChangesStep.$getCallSiteArray()[156].call(Time.class, (Object)15);
        ADDITIONAL_CHANGES_CHECK_DELAY = (Time)ScriptBytecodeAdapter.castToType((Object)object2, Time.class);
    }

    public String getRepositoriesContentSkipProperty() {
        return this.repositoriesContentSkipProperty;
    }

    public void setRepositoriesContentSkipProperty(String string) {
        this.repositoriesContentSkipProperty = string;
    }

    public MigrationService getMigrationService() {
        return this.migrationService;
    }

    public void setMigrationService(MigrationService migrationService) {
        this.migrationService = migrationService;
    }

    public RepositoryMigrationManager getRepositoryMigrationManager() {
        return this.repositoryMigrationManager;
    }

    public void setRepositoryMigrationManager(RepositoryMigrationManager repositoryMigrationManager) {
        this.repositoryMigrationManager = repositoryMigrationManager;
    }

    public RepositoryChangelogClient getRepositoryChangelogClient() {
        return this.repositoryChangelogClient;
    }

    public void setRepositoryChangelogClient(RepositoryChangelogClient repositoryChangelogClient) {
        this.repositoryChangelogClient = repositoryChangelogClient;
    }

    public RequestMonitorController getHttpController() {
        return this.httpController;
    }

    public void setHttpController(RequestMonitorController requestMonitorController) {
        this.httpController = requestMonitorController;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public /* synthetic */ void super$3$doConfigure(Map map) {
        super.doConfigure(map);
    }

    public /* synthetic */ void super$3$doInit() {
        super.doInit();
    }

    public /* synthetic */ void super$3$doAbort() {
        super.doAbort();
    }

    public /* synthetic */ void super$3$doDestroy() {
        super.doDestroy();
    }

    public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "SYNC";
        stringArray[5] = "assistant";
        stringArray[6] = "get";
        stringArray[7] = "getInteger";
        stringArray[8] = "plus";
        stringArray[9] = "name";
        stringArray[10] = "info";
        stringArray[11] = "log";
        stringArray[12] = "forFixedSubject";
        stringArray[13] = "newFixedThreadPool";
        stringArray[14] = "<$constructor$>";
        stringArray[15] = "TASK_SUBJECT";
        stringArray[16] = "<$constructor$>";
        stringArray[17] = "register";
        stringArray[18] = "getRepositoriesContentSkip";
        stringArray[19] = "empty";
        stringArray[20] = "info";
        stringArray[21] = "log";
        stringArray[22] = "emptySet";
        stringArray[23] = "split";
        stringArray[24] = "collect";
        stringArray[25] = "map";
        stringArray[26] = "stream";
        stringArray[27] = "toSet";
        stringArray[28] = "close";
        stringArray[29] = "shutdownNow";
        stringArray[30] = "unregister";
        stringArray[31] = "currentTimeMillis";
        stringArray[32] = "shouldRun";
        stringArray[33] = "sync";
        stringArray[34] = "currentTimeMillis";
        stringArray[35] = "debug";
        stringArray[36] = "log";
        stringArray[37] = "simplify";
        stringArray[38] = "minus";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "<$constructor$>";
        stringArray[41] = "failedText";
        stringArray[42] = "sleep";
        stringArray[43] = "days";
        stringArray[44] = "days";
        stringArray[45] = "hours";
        stringArray[46] = "hours";
        stringArray[47] = "minutes";
        stringArray[48] = "minutes";
        stringArray[49] = "seconds";
        stringArray[50] = "seconds";
        stringArray[51] = "days";
        stringArray[52] = "hours";
        stringArray[53] = "minutes";
        stringArray[54] = "aborted";
        stringArray[55] = "get";
        stringArray[56] = "aborted";
        stringArray[57] = "get";
        stringArray[58] = "get";
        stringArray[59] = "forceContinueEnabled";
        stringArray[60] = "get";
        stringArray[61] = "set";
        stringArray[62] = "<$constructor$>";
        stringArray[63] = "onOrderedCompletion";
        stringArray[64] = "iterator";
        stringArray[65] = "after";
        stringArray[66] = "get";
        stringArray[67] = "fetchSize";
        stringArray[68] = "assistant";
        stringArray[69] = "peekingIterator";
        stringArray[70] = "hasNext";
        stringArray[71] = "trace";
        stringArray[72] = "log";
        stringArray[73] = "set";
        stringArray[74] = "hasNext";
        stringArray[75] = "isEmpty";
        stringArray[76] = "trace";
        stringArray[77] = "log";
        stringArray[78] = "plus";
        stringArray[79] = "plus";
        stringArray[80] = "plus";
        stringArray[81] = "hasNext";
        stringArray[82] = "size";
        stringArray[83] = "failedText";
        stringArray[84] = "hasNext";
        stringArray[85] = "size";
        stringArray[86] = "shouldRun";
        stringArray[87] = "add";
        stringArray[88] = "progressLog";
        stringArray[89] = "info";
        stringArray[90] = "log";
        stringArray[91] = "failedText";
        stringArray[92] = "peek";
        stringArray[93] = "repositoryId";
        stringArray[94] = "isTraceEnabled";
        stringArray[95] = "log";
        stringArray[96] = "trace";
        stringArray[97] = "log";
        stringArray[98] = "type";
        stringArray[99] = "change";
        stringArray[100] = "component";
        stringArray[101] = "change";
        stringArray[102] = "next";
        stringArray[103] = "calculatePath";
        stringArray[104] = "add";
        stringArray[105] = "submit";
        stringArray[106] = "next";
        stringArray[107] = "next";
        stringArray[108] = "shouldRun";
        stringArray[109] = "isEmpty";
        stringArray[110] = "take";
        stringArray[111] = "calculatedPath";
        stringArray[112] = "remove";
        stringArray[113] = "hasNext";
        stringArray[114] = "peek";
        stringArray[115] = "calculatePath";
        stringArray[116] = "next";
        stringArray[117] = "successful";
        stringArray[118] = "repositoryId";
        stringArray[119] = "changeType";
        stringArray[120] = "exception";
        stringArray[121] = "add";
        stringArray[122] = "progressLog";
        stringArray[123] = "message";
        stringArray[124] = "isDebugEnabled";
        stringArray[125] = "log";
        stringArray[126] = "error";
        stringArray[127] = "log";
        stringArray[128] = "message";
        stringArray[129] = "error";
        stringArray[130] = "log";
        stringArray[131] = "message";
        stringArray[132] = "next";
        stringArray[133] = "failedText";
        stringArray[134] = "get";
        stringArray[135] = "info";
        stringArray[136] = "log";
        stringArray[137] = "trace";
        stringArray[138] = "log";
        stringArray[139] = "set";
        stringArray[140] = "findMigrator";
        stringArray[141] = "repositoryId";
        stringArray[142] = "path";
        stringArray[143] = "change";
        stringArray[144] = "calculatePath";
        stringArray[145] = "start";
        stringArray[146] = "id";
        stringArray[147] = "submit";
        stringArray[148] = "add";
        stringArray[149] = "progressLog";
        stringArray[150] = "disconnectDescription";
        stringArray[151] = "delayUntil";
        stringArray[152] = "add";
        stringArray[153] = "progressLog";
        stringArray[154] = "availableProcessors";
        stringArray[155] = "getRuntime";
        stringArray[156] = "seconds";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[157];
        ProcessChangesStep.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ProcessChangesStep.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ProcessChangesStep.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static class ProcessingResult
    implements GroovyObject {
        private String changeId;
        private String changeType;
        private String repositoryId;
        private String calculatedPath;
        private Exception exception;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ProcessingResult() {
            MetaClass metaClass;
            CallSite[] callSiteArray = ProcessingResult.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public boolean isSuccessful() {
            CallSite[] callSiteArray = ProcessingResult.$getCallSiteArray();
            return !DefaultTypeTransformation.booleanUnbox((Object)this.exception);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ProcessingResult.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ProcessingResult.class, ProcessChangesStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ProcessingResult.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ProcessingResult.class, ProcessChangesStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ProcessingResult.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ProcessChangesStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ProcessingResult.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ProcessChangesStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ProcessingResult.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ProcessingResult.class, ProcessChangesStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ProcessingResult.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ProcessingResult.class, ProcessChangesStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ProcessingResult.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public String getChangeId() {
            return this.changeId;
        }

        public void setChangeId(String string) {
            this.changeId = string;
        }

        public String getChangeType() {
            return this.changeType;
        }

        public void setChangeType(String string) {
            this.changeType = string;
        }

        public String getRepositoryId() {
            return this.repositoryId;
        }

        public void setRepositoryId(String string) {
            this.repositoryId = string;
        }

        public String getCalculatedPath() {
            return this.calculatedPath;
        }

        public void setCalculatedPath(String string) {
            this.calculatedPath = string;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(ProcessingResult.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ProcessingResult.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

