/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository;

import com.google.common.base.Preconditions;
import java.util.SortedSet;
import java.util.TreeSet;

public class CompletionOrderHelper<T> {
    private SortedSet<T> started = new TreeSet<T>();
    private SortedSet<T> completed = new TreeSet<T>();
    private Callback<T> callback;

    public synchronized void start(T id) {
        Preconditions.checkNotNull(id);
        this.started.add(id);
    }

    public synchronized void complete(T id) {
        Preconditions.checkNotNull(id);
        Preconditions.checkState((boolean)this.started.contains(id), (String)"id %s not in started list", id);
        this.completed.add(id);
        Object idForNotification = null;
        while (this.earliestStartedHasCompleted()) {
            idForNotification = this.started.first();
            this.started.remove(idForNotification);
            this.completed.remove(idForNotification);
        }
        if (idForNotification != null && this.callback != null) {
            this.callback.onOrderedCompletion(idForNotification);
        }
    }

    public synchronized void abort(T id) {
        Preconditions.checkState((boolean)this.started.remove(id), (String)"id %s not in started list", id);
        this.completed.remove(id);
    }

    private boolean earliestStartedHasCompleted() {
        return !this.started.isEmpty() && !this.completed.isEmpty() && this.started.first().equals(this.completed.first());
    }

    public synchronized void onOrderedCompletion(Callback<T> callback) {
        this.callback = callback;
    }

    public static interface Callback<T> {
        public void onOrderedCompletion(T var1);
    }
}

