/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.plan;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Locks;

public class ProgressLog
extends ComponentSupport
implements Iterable<ProgressEntry> {
    public static final int DEFAULT_MAX_SIZE = 64;
    private final EvictingQueue<ProgressEntry> entries;
    private final ReadWriteLock readWriteLock;

    public ProgressLog(int maxSize) {
        this.entries = EvictingQueue.create((int)maxSize);
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    public ProgressLog() {
        this(64);
    }

    @VisibleForTesting
    EvictingQueue<ProgressEntry> getEntries() {
        return this.entries;
    }

    public void add(ProgressEntry entry) {
        Lock lock = Locks.write((ReadWriteLock)this.readWriteLock);
        try {
            this.entries.add((Object)entry);
        }
        finally {
            lock.unlock();
        }
    }

    public void add(String message, Object ... args) {
        this.add(new ProgressEntry(message, args));
    }

    public int size() {
        Lock lock = Locks.read((ReadWriteLock)this.readWriteLock);
        try {
            int n = this.entries.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isEmpty() {
        Lock lock = Locks.read((ReadWriteLock)this.readWriteLock);
        try {
            boolean bl = this.entries.isEmpty();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void clear() {
        Lock lock = Locks.write((ReadWriteLock)this.readWriteLock);
        try {
            this.entries.clear();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Iterator<ProgressEntry> iterator() {
        Lock lock = Locks.read((ReadWriteLock)this.readWriteLock);
        try {
            UnmodifiableIterator unmodifiableIterator = Iterators.forArray((Object[])((ProgressEntry[])this.entries.toArray((Object[])new ProgressEntry[this.entries.size()])));
            return unmodifiableIterator;
        }
        finally {
            lock.unlock();
        }
    }

    public static class ProgressEntry {
        private final DateTime timestamp = DateTime.now();
        private final String message;

        public ProgressEntry(String message, Object ... args) {
            this.message = args == null || args.length == 0 ? message : String.format(message, args);
        }

        public DateTime getTimestamp() {
            return this.timestamp;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return String.format("%s: %s", this.timestamp, this.message);
        }
    }
}

