/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.firewall.datastore;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import com.sonatype.nexus.clm.migration.datastore.DatastoreFirewallMigrationHelper;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.firewall.AbstractEnabledFirewallMigrationFacadeImpl;
import com.sonatype.nexus.migration.firewall.datastore.DatastoreFirewallMigrationFacade;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
@Singleton
@Priority(value=0x7FFFFFFE)
public class DatastoreEnabledFirewallMigrationFacadeImpl
extends AbstractEnabledFirewallMigrationFacadeImpl<DatastoreFirewallMigrationHelper>
implements DatastoreFirewallMigrationFacade {
    private static final String IQ_ITEM_ATTRIBUTES = "iqItemAttributes";
    private static final TypeToken<Map<String, Object>> IQ_ITEM_ATTRIBUTES_TYPE = new TypeToken<Map<String, Object>>(){};

    @Inject
    public DatastoreEnabledFirewallMigrationFacadeImpl(DatastoreFirewallMigrationHelper firewallMigrationHelper, RepositoryManager repositoryManager) {
        super(firewallMigrationHelper, repositoryManager);
    }

    @Override
    public void maybeRecordAssetAttributes(Repository repository, RepositoryChangelogClient.ChangeEntryXO change, Supplier<Asset> assetSupplier) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)change);
        Preconditions.checkNotNull(assetSupplier);
        NestedAttributesMap assetAttributes = change.getChange().getAsset().attributes();
        Map iqAttributes = (Map)assetAttributes.get(IQ_ITEM_ATTRIBUTES, IQ_ITEM_ATTRIBUTES_TYPE);
        if (iqAttributes != null) {
            this.updateAssetAttributes(repository, assetSupplier, iqAttributes);
        }
    }

    private void updateAssetAttributes(Repository repository, Supplier<Asset> assetSupplier, Map<String, Object> iqAttributes) {
        Asset asset = assetSupplier.get();
        if (asset != null) {
            ((DatastoreFirewallMigrationHelper)this.firewallMigrationHelper).ingestAssetAttributes(repository, asset, iqAttributes);
        }
    }
}

