/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.client.http;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.client.http.ClientRequestMonitor;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.sonatype.nexus.repository.httpclient.FilteredHttpClientSupport;

public class MonitoredHttpClient
extends FilteredHttpClientSupport {
    private final ClientRequestMonitor monitor;

    public MonitoredHttpClient(CloseableHttpClient delegate, ClientRequestMonitor monitor) {
        super(delegate);
        this.monitor = (ClientRequestMonitor)Preconditions.checkNotNull((Object)monitor);
    }

    protected CloseableHttpResponse filter(HttpHost target, FilteredHttpClientSupport.Filterable filterable) throws IOException {
        this.monitor.maybeDelayRequest();
        try {
            CloseableHttpResponse response = filterable.call();
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() >= 500) {
                this.monitor.requestFailed(statusLine.getReasonPhrase());
                return response;
            }
            this.monitor.requestSuccessful();
            return response;
        }
        catch (IOException e) {
            this.monitor.requestFailed(e.getMessage());
            throw e;
        }
    }
}

