/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.client.http;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.client.http.ClientRequestMonitor;
import com.sonatype.nexus.migration.client.http.MigrationConnectionStatusEvent;
import com.sonatype.nexus.migration.client.http.MigrationDisconnectionEvent;
import com.sonatype.nexus.migration.client.http.MigrationReconnectionEvent;
import com.sonatype.nexus.migration.client.http.RequestMonitorController;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.sequence.FibonacciNumberSequence;
import org.sonatype.nexus.common.sequence.NumberSequence;
import org.sonatype.nexus.common.time.Clock;

@Named
@Singleton
public class MigrationRequestMonitorImpl
extends ComponentSupport
implements RequestMonitorController,
ClientRequestMonitor {
    @VisibleForTesting
    static final int SLEEP_INCREMENT_MILLIS = 1000;
    private final EventManager eventManager;
    @VisibleForTesting
    Clock clock = new Clock();
    private AtomicBoolean indefiniteRetry = new AtomicBoolean(false);
    private NumberSequence delaySequence = new FibonacciNumberSequence(Time.seconds((long)5L).toMillis());
    private Long delayUntil = null;
    private boolean failureMode = false;

    @Inject
    public MigrationRequestMonitorImpl(EventManager eventManager) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    @Override
    public boolean isIndefiniteRetry() {
        return this.indefiniteRetry.get();
    }

    @Override
    public synchronized void setIndefiniteRetry(boolean enabled) {
        this.log.info("Upgrade HTTP connection indefinite retry {}", (Object)enabled);
        if (enabled && !this.indefiniteRetry.get()) {
            this.delaySequence.reset();
        }
        this.indefiniteRetry.set(enabled);
    }

    @Override
    public MigrationConnectionStatusEvent getStatus() {
        return null;
    }

    @Override
    public long maybeDelayRequest() {
        long sleepTime = 0L;
        this.log.trace("checking blocked status");
        while (this.shouldSleep()) {
            sleepTime += this.sleep();
        }
        return sleepTime;
    }

    @VisibleForTesting
    long sleep() {
        try {
            Thread.sleep(1000L);
            return 1000L;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized boolean shouldSleep() {
        if (!this.indefiniteRetry.get() || !this.failureMode) {
            return false;
        }
        return this.clock.millis() < this.delayUntil;
    }

    @Override
    public synchronized void requestSuccessful() {
        if (!this.failureMode) {
            this.log.trace("Successful request during normal operation");
            return;
        }
        this.log.warn("Leaving failure mode");
        this.failureMode = false;
        this.delayUntil = null;
        this.eventManager.post((Object)new MigrationReconnectionEvent());
    }

    @Override
    public synchronized void requestFailed(String failureDescription) {
        if (!this.failureMode) {
            this.log.warn("Request failed: {}", (Object)failureDescription);
            this.failureMode = true;
            this.delaySequence.reset();
        } else {
            this.log.info("Request failed during failure mode: {}", (Object)failureDescription);
        }
        if (this.delayUntil == null || this.clock.millis() >= this.delayUntil) {
            this.delayUntil = this.clock.millis() + this.delaySequence.next();
            this.log.info("Delaying until {}", (Object)new Date(this.delayUntil));
        }
        this.eventManager.post((Object)new MigrationDisconnectionEvent(failureDescription, new Date(this.delayUntil)));
    }
}

