/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.orient.internal.proxy;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.r.AssetKind;
import com.sonatype.nexus.repository.r.internal.util.RDescriptionUtils;
import com.sonatype.nexus.repository.r.internal.util.RMetadataUtils;
import com.sonatype.nexus.repository.r.internal.util.RPathUtils;
import com.sonatype.nexus.repository.r.orient.OrientRFacet;
import com.sonatype.nexus.repository.r.orient.util.OrientRFacetUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientRProxyFacetImpl
extends ProxyFacetSupport {
    protected void doValidate(Configuration configuration) throws Exception {
        super.doValidate(configuration);
    }

    @Nullable
    protected Content getCachedContent(Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        switch (assetKind) {
            case PACKAGES: 
            case RDS_METADATA: 
            case ARCHIVE: {
                return this.getAsset(RPathUtils.extractRequestPath(context));
            }
        }
        throw new IllegalStateException();
    }

    protected Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        switch (assetKind) {
            case PACKAGES: 
            case RDS_METADATA: {
                return this.putMetadata(RPathUtils.extractRequestPath(context), content);
            }
            case ARCHIVE: {
                return this.putArchive(RPathUtils.extractRequestPath(context), content);
            }
        }
        throw new IllegalStateException();
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) throws IOException {
        this.setCacheInfo(content, cacheInfo);
    }

    @TransactionalTouchMetadata
    public void setCacheInfo(Content content, CacheInfo cacheInfo) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)tx.findBucket(this.getRepository()), (Content)content);
        if (asset == null) {
            this.log.debug("Attempting to set cache info for non-existent R asset {}", content.getAttributes().require(Asset.class));
            return;
        }
        this.log.debug("Updating cacheInfo of {} to {}", (Object)asset, (Object)cacheInfo);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)cacheInfo);
        tx.saveAsset(asset);
    }

    private Content putArchive(String path, Content content) throws IOException {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)content);
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content.openInputStream(), RMetadataUtils.HASH_ALGORITHMS);){
            return this.doPutArchive(path, tempBlob, content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutArchive(String path, TempBlob archiveContent, Content content) throws IOException {
        Map<String, String> attributes;
        OrientRFacet rFacet = (OrientRFacet)this.facet(OrientRFacet.class);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Throwable throwable = null;
        Object var8_8 = null;
        try (InputStream is = archiveContent.get();){
            attributes = RDescriptionUtils.extractDescriptionFromArchive(path, is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Component component = rFacet.findOrCreateComponent(tx, path, attributes);
        Asset asset = rFacet.findOrCreateAsset(tx, component, path, attributes);
        return OrientRFacetUtils.saveAsset(tx, asset, (InputStreamSupplier)archiveContent, (Payload)content);
    }

    private Content putMetadata(String path, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content.openInputStream(), RMetadataUtils.HASH_ALGORITHMS);){
            return this.doPutMetadata(path, tempBlob, (Payload)content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutMetadata(String path, TempBlob packagesContent, Payload payload) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        OrientRFacet rFacet = (OrientRFacet)this.facet(OrientRFacet.class);
        Asset asset = rFacet.findOrCreateAsset(tx, path);
        return OrientRFacetUtils.saveAsset(tx, asset, (InputStreamSupplier)packagesContent, payload);
    }

    @TransactionalTouchBlob
    protected Content getAsset(String name) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = OrientRFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), name);
        if (asset == null) {
            return null;
        }
        if (asset.markAsDownloaded()) {
            tx.saveAsset(asset);
        }
        return OrientRFacetUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    protected String getUrl(@Nonnull Context context) {
        return context.getRequest().getPath().substring(1);
    }

    protected CacheController getCacheController(Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        return (CacheController)Preconditions.checkNotNull((Object)this.cacheControllerHolder.get(assetKind.getCacheType()));
    }
}

